/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.StringData;
import net.Indyuce.mmoitems.stat.type.StringStat;
import net.Indyuce.mmoitems.util.MMOUtils;
import net.Indyuce.mmoitems.util.StatChoice;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseStat
extends StringStat {
    private final List<StatChoice> choices = new ArrayList<StatChoice>();

    public ChooseStat(String id, Material mat, String name, String[] lore, String[] types, Material ... materials) {
        super(id, mat, name, lore, types, materials);
    }

    public void addChoices(StatChoice ... choices) {
        this.choices.addAll(Arrays.asList(choices));
    }

    @Nullable
    public StatChoice getChoice(String id) {
        for (StatChoice choice : this.choices) {
            if (!choice.getId().equals(id)) continue;
            return choice;
        }
        return null;
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        Validate.isTrue((!this.choices.isEmpty() ? 1 : 0) != 0, (String)("Invalid choice-based stat '" + this.getId() + ": no options to choose from."));
        if (event.getAction() == InventoryAction.PICKUP_HALF) {
            inv.getEditedSection().set(this.getPath(), null);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully removed " + this.getName() + ".");
        } else {
            int currentIndex;
            String found = inv.getEditedSection().getString(this.getPath());
            int n = currentIndex = found == null ? -1 : this.choices.indexOf(this.getChoice(found));
            if (++currentIndex >= this.choices.size()) {
                currentIndex = 0;
            }
            StatChoice current = this.choices.get(currentIndex);
            inv.getEditedSection().set(this.getPath(), (Object)current.getId());
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + this.getName() + " successfully changed to " + current + ChatColor.GRAY + ".");
        }
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<StringData> statData) {
        Validate.isTrue((!this.choices.isEmpty() ? 1 : 0) != 0, (String)("Invalid choice-based stat '" + this.getId() + ": no options to choose from."));
        StatChoice found = statData.isPresent() ? this.getChoice(statData.get().toString()) : null;
        lore.add(ChatColor.GRAY + "Current Value: " + (found != null ? ChatColor.GREEN + found.getId() : ChatColor.RED + "None"));
        if (found != null && found.getHint() != null) {
            for (String definition : MMOUtils.trimString(50, found.getHint())) {
                lore.add(ChatColor.GRAY + " " + definition);
            }
        }
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to return to default value.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Left click to cycle through the available options:");
        for (StatChoice existing : this.choices) {
            String pick = existing.equals(found) ? ChatColor.RED.toString() + ChatColor.BOLD : ChatColor.GOLD.toString();
            lore.add(pick + "  " + "\u25b8" + " " + ChatColor.GRAY + existing.getId());
        }
    }
}

