/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.type;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.BooleanData;
import net.Indyuce.mmoitems.stat.data.random.RandomBooleanData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanStat
extends ItemStat<RandomBooleanData, BooleanData> {
    public BooleanStat(String id, Material mat, String name, String[] lore, String[] types, Material ... materials) {
        super(id, mat, name, lore, types, materials);
    }

    @Override
    public RandomBooleanData whenInitialized(Object object) {
        if (object instanceof Boolean) {
            return new RandomBooleanData((Boolean)object);
        }
        if (object instanceof Number) {
            return new RandomBooleanData(Double.parseDouble(object.toString()));
        }
        throw new IllegalArgumentException("Must specify a number (chance) or true/false");
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull BooleanData data) {
        if (data.isEnabled()) {
            item.addItemTag(this.getAppliedNBT(data));
            item.getLore().insert(this.getPath(), this.getGeneralStatFormat());
        }
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull BooleanData data) {
        ArrayList<ItemTag> ret = new ArrayList<ItemTag>();
        if (data.isEnabled()) {
            ret.add(new ItemTag(this.getNBTPath(), (Object)true));
        }
        return ret;
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            inv.getEditedSection().set(this.getPath(), (Object)(inv.getEditedSection().getBoolean(this.getPath()) ? null : Boolean.valueOf(true)));
            inv.registerTemplateEdition();
        } else if (event.getAction() == InventoryAction.PICKUP_HALF) {
            new StatEdition(inv, this, new Object[0]).enable("Write in the chat the probability you want (a percentage)");
        }
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        double probability = MMOUtils.parseDouble(message);
        Validate.isTrue((probability >= 0.0 && probability <= 100.0 ? 1 : 0) != 0, (String)"Chance must be between 0 and 100");
        inv.getEditedSection().set(this.getPath(), (Object)(probability / 100.0));
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + this.getName() + " successfully changed to " + ChatColor.GREEN + MythicLib.plugin.getMMOConfig().decimal.format(probability) + "% Chance" + ChatColor.GRAY + ".");
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        StatData data;
        ArrayList<ItemTag> relevantTags = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            relevantTags.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.BOOLEAN));
        }
        if ((data = this.getLoadedNBT((ArrayList)relevantTags)) != null) {
            mmoitem.setData(this, data);
        }
    }

    @Override
    @Nullable
    public BooleanData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag encoded = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (encoded != null) {
            return new BooleanData((Boolean)encoded.getValue());
        }
        return null;
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<RandomBooleanData> statData) {
        if (statData.isPresent()) {
            double chance = statData.get().getChance();
            lore.add(ChatColor.GRAY + "Current Value: " + (chance >= 1.0 ? ChatColor.GREEN + "True" : (chance <= 0.0 ? ChatColor.RED + "False" : ChatColor.GREEN + MythicLib.plugin.getMMOConfig().decimal.format(chance * 100.0) + "% Chance")));
        } else {
            lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.RED + "False");
        }
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Left click to switch this value.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to choose a probability to have this option.");
    }

    @Override
    @NotNull
    public BooleanData getClearStatData() {
        return new BooleanData(false);
    }
}

