/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.data.random;

import net.Indyuce.mmoitems.api.item.build.MMOItemBuilder;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.stat.data.RestoreData;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;

public class RandomRestoreData
implements RandomStatData<RestoreData> {
    private final NumericStatFormula health;
    private final NumericStatFormula food;
    private final NumericStatFormula saturation;

    public RandomRestoreData(ConfigurationSection config) {
        Validate.notNull((Object)config, (String)"Could not load restore config");
        this.health = config.contains("health") ? new NumericStatFormula(config) : NumericStatFormula.ZERO;
        this.food = config.contains("food") ? new NumericStatFormula(config) : NumericStatFormula.ZERO;
        this.saturation = config.contains("saturation") ? new NumericStatFormula(config) : NumericStatFormula.ZERO;
    }

    public NumericStatFormula getHealth() {
        return this.health;
    }

    public NumericStatFormula getFood() {
        return this.food;
    }

    public NumericStatFormula getSaturation() {
        return this.saturation;
    }

    @Override
    public RestoreData randomize(MMOItemBuilder builder) {
        return new RestoreData(this.health.calculate(builder.getLevel()), this.food.calculate(builder.getLevel()), this.saturation.calculate(builder.getLevel()));
    }
}

