/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.data.random;

import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.Indyuce.mmoitems.api.item.build.MMOItemBuilder;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.stat.data.PotionEffectData;
import net.Indyuce.mmoitems.stat.data.PotionEffectListData;
import net.Indyuce.mmoitems.stat.data.random.RandomPotionEffectData;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.potion.PotionEffectType;

public class RandomPotionEffectListData
implements RandomStatData<PotionEffectListData> {
    private final List<RandomPotionEffectData> effects = new ArrayList<RandomPotionEffectData>();

    public RandomPotionEffectListData(ConfigurationSection config) {
        Validate.notNull((Object)config, (String)"Config cannot be null");
        for (String key : config.getKeys(false)) {
            ConfigurationSection asSection = config.getConfigurationSection(key);
            if (asSection != null) {
                this.effects.add(new RandomPotionEffectData(asSection));
                continue;
            }
            String spl = config.getString(key);
            if (spl != null) {
                String[] split = spl.split(",");
                if (split.length >= 1) {
                    Double duration = SilentNumbers.DoubleParse((String)split[0]);
                    Integer amplifier = SilentNumbers.IntegerParse((String)split[1]);
                    PotionEffectType effect = PotionEffectType.getByName((String)key.toUpperCase().replace("-", "_").replace(" ", "_"));
                    if (duration != null && amplifier != null && effect != null) {
                        this.effects.add(new RandomPotionEffectData(effect, new NumericStatFormula(duration), new NumericStatFormula(amplifier)));
                        continue;
                    }
                    throw new IllegalArgumentException(FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Incorrect format, expected $e{Effect}: {Duration},{Amplifier}$b instead of $i{0} {1}$b.", (String[])new String[]{key, spl}));
                }
                throw new IllegalArgumentException(FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Incorrect format, expected $e{Effect}: {Duration},{Amplifier}$b instead of $i{0} {1}$b.", (String[])new String[]{key, spl}));
            }
            throw new IllegalArgumentException("Config cannot be null");
        }
    }

    public RandomPotionEffectListData(RandomPotionEffectData ... effects) {
        this.add(effects);
    }

    public void add(RandomPotionEffectData ... effects) {
        this.effects.addAll(Arrays.asList(effects));
    }

    public List<RandomPotionEffectData> getEffects() {
        return this.effects;
    }

    @Override
    public PotionEffectListData randomize(MMOItemBuilder builder) {
        PotionEffectListData list = new PotionEffectListData(new PotionEffectData[0]);
        this.effects.forEach(random -> list.add(random.randomize(builder)));
        return list;
    }
}

