/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.data.random;

import net.Indyuce.mmoitems.api.item.build.MMOItemBuilder;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.stat.data.PotionEffectData;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.potion.PotionEffectType;

public class RandomPotionEffectData {
    private final PotionEffectType type;
    private final NumericStatFormula duration;
    private final NumericStatFormula amplifier;

    public RandomPotionEffectData(ConfigurationSection config) {
        Validate.notNull((Object)config, (String)"Potion effect config cannot be null");
        this.type = PotionEffectType.getByName((String)config.getName().toUpperCase().replace("-", "_").replace(" ", "_"));
        Validate.notNull((Object)this.type, (String)("Could not find potion effect with name '" + config.getName() + "'"));
        this.duration = new NumericStatFormula(config.get("duration"));
        this.amplifier = new NumericStatFormula(config.get("amplifier"));
    }

    public RandomPotionEffectData(PotionEffectType type, NumericStatFormula amplifier) {
        this(type, new NumericStatFormula((double)MMOUtils.getEffectDuration(type) / 20.0, 0.0, 0.0, 0.0), amplifier);
    }

    public RandomPotionEffectData(PotionEffectType type, NumericStatFormula duration, NumericStatFormula amplifier) {
        this.type = type;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    public PotionEffectType getType() {
        return this.type;
    }

    public NumericStatFormula getDuration() {
        return this.duration;
    }

    public NumericStatFormula getAmplifier() {
        return this.amplifier;
    }

    public PotionEffectData randomize(MMOItemBuilder builder) {
        return new PotionEffectData(this.type, this.duration.calculate(builder.getLevel()), (int)this.amplifier.calculate(builder.getLevel()));
    }
}

