/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.data.random;

import io.lumine.mythic.lib.skill.trigger.TriggerType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.item.build.MMOItemBuilder;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.skill.RegisteredSkill;
import net.Indyuce.mmoitems.stat.data.AbilityData;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;

public class RandomAbilityData {
    private final RegisteredSkill ability;
    private final TriggerType triggerType;
    private final Map<String, NumericStatFormula> modifiers = new HashMap<String, NumericStatFormula>();

    public RandomAbilityData(ConfigurationSection config) {
        Validate.isTrue((boolean)config.contains("type"), (String)"Missing ability type");
        Validate.isTrue((boolean)config.contains("mode"), (String)"Missing ability trigger type/casting mode");
        String abilityFormat = config.getString("type").toUpperCase().replace("-", "_").replace(" ", "_");
        Validate.isTrue((boolean)MMOItems.plugin.getSkills().hasSkill(abilityFormat), (String)("Could not find ability called '" + abilityFormat + "'"));
        this.ability = MMOItems.plugin.getSkills().getSkill(abilityFormat);
        String modeFormat = config.getString("mode").toUpperCase().replace("-", "_").replace(" ", "_");
        this.triggerType = MMOUtils.backwardsCompatibleTriggerType(modeFormat);
        for (String key : config.getKeys(false)) {
            if (key.equalsIgnoreCase("mode") || key.equalsIgnoreCase("type") || !this.ability.getHandler().getModifiers().contains(key)) continue;
            this.modifiers.put(key, new NumericStatFormula(config.get(key)));
        }
    }

    public RandomAbilityData(RegisteredSkill ability, TriggerType triggerType) {
        this.ability = ability;
        this.triggerType = triggerType;
    }

    public RegisteredSkill getAbility() {
        return this.ability;
    }

    public TriggerType getTriggerType() {
        return this.triggerType;
    }

    public Set<String> getModifiers() {
        return this.modifiers.keySet();
    }

    public void setModifier(String path, NumericStatFormula value) {
        this.modifiers.put(path, value);
    }

    public boolean hasModifier(String path) {
        return this.modifiers.containsKey(path);
    }

    public NumericStatFormula getModifier(String path) {
        return this.modifiers.get(path);
    }

    public AbilityData randomize(MMOItemBuilder builder) {
        AbilityData data = new AbilityData(this.ability, this.triggerType);
        this.modifiers.forEach((key, formula) -> data.setModifier((String)key, formula.calculate(builder.getLevel())));
        return data;
    }
}

