/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.data;

import io.lumine.mythic.lib.gson.JsonObject;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.UpgradeTemplate;
import net.Indyuce.mmoitems.api.item.build.MMOItemBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeData
implements StatData,
RandomStatData<UpgradeData> {
    @Nullable
    private final String reference;
    @Nullable
    private final String template;
    private final boolean workbench;
    private final boolean destroy;
    private final double success;
    private final int max;
    private final int min;
    private int level;

    @Nullable
    public String getReference() {
        return this.reference;
    }

    public boolean isWorkbench() {
        return this.workbench;
    }

    public boolean isDestroy() {
        return this.destroy;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public UpgradeData(@Nullable String reference, @Nullable String template, boolean workbench, boolean destroy, int max, double success) {
        this(reference, template, workbench, destroy, max, 0, success);
    }

    public UpgradeData(@Nullable String reference, @Nullable String template, boolean workbench, boolean destroy, int max, int min, double success) {
        this.reference = reference;
        this.template = template;
        this.workbench = workbench;
        this.destroy = destroy;
        this.max = max;
        this.min = min;
        this.success = success;
    }

    public UpgradeData(ConfigurationSection section) {
        this.reference = section.getString("reference");
        this.template = section.getString("template");
        this.workbench = section.getBoolean("workbench");
        this.destroy = section.getBoolean("destroy");
        this.max = section.getInt("max");
        this.min = section.getInt("min", 0);
        this.success = section.getDouble("success") / 100.0;
    }

    public UpgradeData(JsonObject object) {
        this.workbench = object.get("Workbench").getAsBoolean();
        this.destroy = object.get("Destroy").getAsBoolean();
        this.template = object.has("Template") ? object.get("Template").getAsString() : null;
        this.reference = object.has("Reference") ? object.get("Reference").getAsString() : null;
        this.level = object.get("Level").getAsInt();
        this.max = object.get("Max").getAsInt();
        this.min = object.has("Min") ? object.get("Min").getAsInt() : 0;
        this.success = object.get("Success").getAsDouble();
    }

    @Nullable
    public UpgradeTemplate getTemplate() {
        if (this.template == null) {
            return null;
        }
        return MMOItems.plugin.getUpgrades().getTemplate(this.template);
    }

    @Nullable
    public String getTemplateName() {
        return this.template;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int l) {
        this.level = l;
    }

    public int getMaxUpgrades() {
        return this.max;
    }

    public boolean canLevelUp() {
        return this.max == 0 || this.level < this.max;
    }

    public boolean destroysOnFail() {
        return this.destroy;
    }

    public double getSuccess() {
        return this.success == 0.0 ? 1.0 : this.success;
    }

    @Deprecated
    public boolean matchesReference(UpgradeData data) {
        return MMOUtils.checkReference(this.reference, data.reference);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public void upgrade(@NotNull MMOItem mmoitem) {
        if (this.getTemplate() == null) {
            MMOItems.plugin.getLogger().warning("Couldn't find upgrade template '" + this.template + "'. Does it exist?");
            return;
        }
        this.getTemplate().upgrade(mmoitem);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.reference != null && !this.reference.isEmpty()) {
            json.addProperty("Reference", this.reference);
        }
        if (this.template != null && !this.template.isEmpty()) {
            json.addProperty("Template", this.template);
        }
        json.addProperty("Workbench", Boolean.valueOf(this.workbench));
        json.addProperty("Destroy", Boolean.valueOf(this.destroy));
        json.addProperty("Level", (Number)this.level);
        json.addProperty("Max", (Number)this.max);
        json.addProperty("Min", (Number)this.min);
        json.addProperty("Success", (Number)this.success);
        return json;
    }

    public String toString() {
        return this.toJson().toString();
    }

    @Override
    public UpgradeData randomize(MMOItemBuilder builder) {
        return this;
    }

    public UpgradeData clone() {
        return new UpgradeData(this.reference, this.template, this.workbench, this.destroy, this.max, this.min, this.success);
    }
}

