/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.data;

import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import io.lumine.mythic.lib.gson.JsonArray;
import java.util.ArrayList;
import java.util.List;
import net.Indyuce.mmoitems.api.item.build.MMOItemBuilder;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import net.Indyuce.mmoitems.stat.data.type.Mergeable;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringListData
implements StatData,
Mergeable<StringListData>,
RandomStatData<StringListData> {
    @NotNull
    private final List<String> list = new ArrayList<String>();

    public boolean equals(Object obj) {
        if (!(obj instanceof StringListData)) {
            return false;
        }
        if (((StringListData)obj).getList().size() != this.getList().size()) {
            return false;
        }
        return SilentNumbers.hasAll(((StringListData)obj).getList(), this.getList());
    }

    public StringListData() {
    }

    public StringListData(@NotNull String[] array) {
        for (String str : array) {
            this.list.add(str);
        }
    }

    public StringListData(@NotNull JsonArray array) {
        array.forEach(str -> this.list.add(str.getAsString()));
    }

    public StringListData(@NotNull List<String> list) {
        this.list.addAll(list);
    }

    @NotNull
    public List<String> getList() {
        return this.list;
    }

    @Override
    public StringListData randomize(MMOItemBuilder builder) {
        return new StringListData(new ArrayList<String>(this.list));
    }

    @Override
    public void mergeWith(StringListData data) {
        this.list.addAll(data.list);
    }

    @Override
    @NotNull
    public StringListData clone() {
        return new StringListData(this.list);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public String toString() {
        StringBuilder b = new StringBuilder("\u00a77");
        for (String str : this.getList()) {
            if (b.length() > 0) {
                b.append("\u00a78;\u00a77 ");
            }
            b.append(str);
        }
        return b.toString();
    }

    @Deprecated
    public boolean remove(@Nullable String str) {
        return this.list.remove(str);
    }
}

