/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.data;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.Indyuce.mmoitems.api.CustomSound;
import net.Indyuce.mmoitems.api.item.build.MMOItemBuilder;
import net.Indyuce.mmoitems.stat.data.SoundData;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import net.Indyuce.mmoitems.stat.data.type.Mergeable;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import org.jetbrains.annotations.NotNull;

public class SoundListData
implements StatData,
Mergeable<SoundListData>,
RandomStatData<SoundListData> {
    private final Map<CustomSound, SoundData> sounds = new LinkedHashMap<CustomSound, SoundData>();

    public SoundListData() {
    }

    public SoundListData(@NotNull Map<CustomSound, SoundData> sounds) {
        sounds.forEach(this.sounds::put);
    }

    public Set<CustomSound> getCustomSounds() {
        return this.sounds.keySet();
    }

    public Map<CustomSound, SoundData> mapData() {
        return this.sounds;
    }

    @Nullable
    public SoundData get(CustomSound sound) {
        return this.sounds.getOrDefault((Object)sound, null);
    }

    public void set(CustomSound type, SoundData data) {
        this.sounds.put(type, data);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SoundListData)) {
            return false;
        }
        if (((SoundListData)obj).getCustomSounds().size() != this.getCustomSounds().size()) {
            return false;
        }
        for (CustomSound sound : ((SoundListData)obj).getCustomSounds()) {
            if (sound == null) continue;
            boolean unmatched = true;
            for (CustomSound thi : this.getCustomSounds()) {
                if (!sound.equals((Object)thi)) continue;
                unmatched = false;
                break;
            }
            if (!unmatched) continue;
            return false;
        }
        return true;
    }

    @Override
    public void mergeWith(SoundListData targetData) {
        targetData.sounds.forEach(this.sounds::put);
    }

    @Override
    @NotNull
    public SoundListData clone() {
        return new SoundListData(this.mapData());
    }

    @Override
    public boolean isEmpty() {
        return this.sounds.isEmpty();
    }

    @Override
    public SoundListData randomize(MMOItemBuilder builder) {
        return new SoundListData(new HashMap<CustomSound, SoundData>(this.sounds));
    }
}

