/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.data;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.gson.JsonObject;
import io.lumine.mythic.lib.version.VParticle;
import net.Indyuce.mmoitems.api.item.build.MMOItemBuilder;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;

public class ProjectileParticlesData
implements StatData,
RandomStatData<ProjectileParticlesData> {
    private final Particle particle;
    private final int red;
    private final int green;
    private final int blue;
    private final boolean colored;
    public static final ProjectileParticlesData DEFAULT = new ProjectileParticlesData(Particle.NOTE);

    public ProjectileParticlesData(Particle particle) {
        this.particle = particle;
        this.red = 0;
        this.green = 0;
        this.blue = 0;
        this.colored = false;
    }

    public ProjectileParticlesData(Particle particle, int red, int green, int blue) {
        this.particle = particle;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.colored = true;
    }

    public ProjectileParticlesData(String jsonObject) {
        JsonObject obj = (JsonObject)MythicLib.plugin.getGson().fromJson(jsonObject, JsonObject.class);
        this.particle = Particle.valueOf((String)obj.get("Particle").getAsString());
        if (MMOUtils.isColorable(this.particle)) {
            this.colored = true;
            this.red = obj.get("Red").getAsInt();
            this.green = obj.get("Green").getAsInt();
            this.blue = obj.get("Blue").getAsInt();
        } else {
            this.colored = false;
            this.red = 0;
            this.green = 0;
            this.blue = 0;
        }
    }

    public Particle getParticle() {
        return this.particle;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Deprecated
    public static boolean isColorable(Particle particle) {
        return MMOUtils.isColorable(particle);
    }

    public String toString() {
        JsonObject object = new JsonObject();
        object.addProperty("Particle", this.particle.name());
        if (this.colored) {
            object.addProperty("Red", (Number)this.red);
            object.addProperty("Green", (Number)this.green);
            object.addProperty("Blue", (Number)this.blue);
        }
        return object.toString();
    }

    public void shootParticle(Location loc) {
        this.shootParticle(loc, 1, 0.0);
    }

    public void shootParticle(Location loc, int amount, double offset) {
        if (MMOUtils.isColorable(this.particle)) {
            if (this.particle == VParticle.REDSTONE.get()) {
                Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)this.red, (int)this.green, (int)this.blue), 1.0f);
                loc.getWorld().spawnParticle(this.particle, loc, amount, offset, offset, offset, 0.0, (Object)dustOptions);
            } else if (this.particle == Particle.NOTE) {
                double note = (double)this.red / 24.0;
                loc.getWorld().spawnParticle(Particle.NOTE, loc, 0, note, 0.0, 0.0, 1.0);
            } else {
                double red = (double)this.red / 255.0;
                double green = (double)this.green / 255.0;
                double blue = (double)this.blue / 255.0;
                loc.getWorld().spawnParticle(this.particle, loc, 0, red, green, blue, 1.0);
            }
        } else if (this.particle == VParticle.ITEM.get()) {
            ItemStack materialData = new ItemStack(Material.STONE);
            loc.getWorld().spawnParticle(this.particle, loc, amount, offset, offset, offset, 0.0, (Object)materialData);
        } else if (this.particle == VParticle.BLOCK.get() || this.particle == VParticle.BLOCK_DUST.get() || this.particle == Particle.FALLING_DUST) {
            BlockData fallingDustData = Material.STONE.createBlockData();
            loc.getWorld().spawnParticle(this.particle, loc, amount, offset, offset, offset, 0.0, (Object)fallingDustData);
        } else {
            loc.getWorld().spawnParticle(this.particle, loc, amount, offset, offset, offset, 0.0);
        }
    }

    @Override
    public ProjectileParticlesData randomize(MMOItemBuilder builder) {
        return this;
    }
}

