/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.data;

import java.util.Objects;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionEffectData {
    private final PotionEffectType type;
    private final double duration;
    private final int level;

    public PotionEffectData(PotionEffectType type, int level) {
        this(type, (double)MMOUtils.getEffectDuration(type) / 20.0, level);
    }

    public PotionEffectData(PotionEffect effect) {
        this.type = effect.getType();
        this.duration = (double)effect.getDuration() / 20.0;
        this.level = effect.getAmplifier() + 1;
    }

    public PotionEffectData(PotionEffectType type, double duration, int level) {
        this.type = type;
        this.duration = duration;
        this.level = level;
    }

    public PotionEffectType getType() {
        return this.type;
    }

    public double getDuration() {
        return this.duration;
    }

    public int getLevel() {
        return this.level;
    }

    public PotionEffect toEffect() {
        return new PotionEffect(this.type, (int)(this.duration * 20.0), this.level - 1, true, false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PotionEffectData that = (PotionEffectData)o;
        return Double.compare(that.duration, this.duration) == 0 && this.level == that.level && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.duration, this.level);
    }
}

