/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.data;

import io.lumine.mythic.lib.gson.JsonElement;
import io.lumine.mythic.lib.gson.JsonObject;
import io.lumine.mythic.lib.version.VParticle;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.item.build.MMOItemBuilder;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.particle.api.ParticleRunnable;
import net.Indyuce.mmoitems.particle.api.ParticleType;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class ParticleData
implements StatData,
RandomStatData<ParticleData> {
    private final ParticleType type;
    private final Particle particle;
    private final Map<String, Double> modifiers = new HashMap<String, Double>();
    private final Color color;

    public ParticleData(JsonObject object) {
        this.particle = Particle.valueOf((String)object.get("Particle").getAsString());
        this.type = ParticleType.valueOf(object.get("Type").getAsString());
        if (object.has("Color")) {
            JsonObject color = object.getAsJsonObject("Color");
            this.color = Color.fromRGB((int)color.get("Red").getAsInt(), (int)color.get("Green").getAsInt(), (int)color.get("Blue").getAsInt());
        } else {
            this.color = Color.fromRGB((int)255, (int)0, (int)0);
        }
        object.getAsJsonObject("Modifiers").entrySet().forEach(entry -> this.setModifier((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsDouble()));
    }

    public ParticleData(ConfigurationSection config) {
        Validate.isTrue((config.contains("type") && config.contains("particle") ? 1 : 0) != 0, (String)"Particle is missing type or selected particle.");
        String format = config.getString("type").toUpperCase().replace("-", "_").replace(" ", "_");
        this.type = ParticleType.valueOf(format);
        format = config.getString("particle").toUpperCase().replace("-", "_").replace(" ", "_");
        this.particle = Particle.valueOf((String)format);
        this.color = config.contains("color") ? Color.fromRGB((int)config.getInt("color.red"), (int)config.getInt("color.green"), (int)config.getInt("color.blue")) : Color.fromRGB((int)255, (int)0, (int)0);
        for (String key : config.getKeys(false)) {
            if (key.equalsIgnoreCase("particle") || key.equalsIgnoreCase("type") || key.equalsIgnoreCase("color")) continue;
            this.setModifier(key, config.getDouble(key));
        }
    }

    public ParticleData(ParticleType type, Particle particle) {
        this.type = type;
        this.particle = particle;
        this.color = Color.fromRGB((int)255, (int)0, (int)0);
    }

    public ParticleType getType() {
        return this.type;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public Color getColor() {
        return this.color;
    }

    public double getModifier(String path) {
        return this.modifiers.containsKey(path) ? this.modifiers.get(path).doubleValue() : this.type.getModifier(path);
    }

    public Set<String> getModifiers() {
        return this.modifiers.keySet();
    }

    public void setModifier(String path, double value) {
        this.modifiers.put(path, value);
    }

    public void display(Location location, float speed) {
        this.display(location, 1, 0.0f, 0.0f, 0.0f, speed);
    }

    public void display(Location location, int amount, float offsetX, float offsetY, float offsetZ, float speed) {
        if (this.particle == VParticle.REDSTONE.get()) {
            location.getWorld().spawnParticle(this.particle, location, amount, (double)offsetX, (double)offsetY, (double)offsetZ, (Object)new Particle.DustOptions(this.color, 1.0f));
        } else if (this.particle == VParticle.ENTITY_EFFECT.get() || this.particle == VParticle.ENTITY_EFFECT_AMBIENT.get()) {
            for (int i = 0; i < amount; ++i) {
                location.getWorld().spawnParticle(this.particle, location, 0, (double)((float)this.color.getRed() / 255.0f), (double)((float)this.color.getGreen() / 255.0f), (double)((float)this.color.getBlue() / 255.0f), 1.0);
            }
        } else {
            location.getWorld().spawnParticle(this.particle, location, amount, (double)offsetX, (double)offsetY, (double)offsetZ, (double)speed);
        }
    }

    public ParticleRunnable start(PlayerData player) {
        ParticleRunnable runnable = this.type.newRunnable(this, player);
        runnable.runTaskTimer((Plugin)MMOItems.plugin, 0L, this.type.getTime());
        return runnable;
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("Particle", this.getParticle().name());
        object.addProperty("Type", this.getType().name());
        if (MMOUtils.isColorable(this.particle)) {
            JsonObject color = new JsonObject();
            color.addProperty("Red", (Number)this.getColor().getRed());
            color.addProperty("Green", (Number)this.getColor().getGreen());
            color.addProperty("Blue", (Number)this.getColor().getBlue());
            object.add("Color", (JsonElement)color);
        }
        JsonObject modifiers = new JsonObject();
        this.getModifiers().forEach(name -> modifiers.addProperty(name, (Number)this.getModifier((String)name)));
        object.add("Modifiers", (JsonElement)modifiers);
        return object;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public ParticleData randomize(MMOItemBuilder builder) {
        return this;
    }

    public void spawn(Location location, Particle particle, int amount, double speed, double offsetX, double offsetY, double offsetZ) {
    }
}

