/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.data;

import org.apache.commons.lang.Validate;

public class CommandData {
    private final String command;
    private final double delay;
    private final boolean console;
    private final boolean op;

    public CommandData(String command, double delay, boolean console, boolean op) {
        Validate.notNull((Object)command, (String)"Command cannot be null");
        this.command = command;
        this.delay = delay;
        this.console = console;
        this.op = op;
    }

    public String getCommand() {
        return this.command;
    }

    public double getDelay() {
        return this.delay;
    }

    public boolean hasDelay() {
        return this.delay > 0.0;
    }

    public boolean isConsoleCommand() {
        return this.console;
    }

    public boolean hasOpPerms() {
        return this.op;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandData that = (CommandData)o;
        return Double.compare(that.delay, this.delay) == 0 && this.console == that.console && this.op == that.op && this.command.equals(that.command);
    }
}

