/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.data;

import net.Indyuce.mmoitems.api.item.build.MMOItemBuilder;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import org.apache.commons.lang.Validate;
import org.bukkit.Color;

public class ColorData
implements StatData,
RandomStatData<ColorData> {
    private final int red;
    private final int green;
    private final int blue;

    public ColorData(String string) {
        String[] split = string.split(" ");
        Validate.isTrue((split.length > 2 ? 1 : 0) != 0, (String)"Must specify 3 numbers for red, green and blue");
        this.red = Math.min(255, Math.max(0, Integer.parseInt(split[0])));
        this.green = Math.min(255, Math.max(0, Integer.parseInt(split[1])));
        this.blue = Math.min(255, Math.max(0, Integer.parseInt(split[2])));
    }

    public ColorData(Color color) {
        this(color.getRed(), color.getGreen(), color.getBlue());
    }

    public ColorData(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public Color getColor() {
        return Color.fromRGB((int)this.red, (int)this.green, (int)this.blue);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        return "{Red=" + this.red + ",Green=" + this.green + ",Blue=" + this.blue + "}";
    }

    @Override
    public ColorData randomize(MMOItemBuilder builder) {
        return this;
    }
}

