/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.data;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.gson.JsonElement;
import io.lumine.mythic.lib.gson.JsonObject;
import io.lumine.mythic.lib.player.cooldown.CooldownInfo;
import io.lumine.mythic.lib.player.cooldown.CooldownObject;
import io.lumine.mythic.lib.skill.Skill;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.trigger.TriggerType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.skill.RegisteredSkill;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class AbilityData
extends Skill {
    private final RegisteredSkill ability;
    @NotNull
    private final Map<String, Double> modifiers = new HashMap<String, Double>();

    public AbilityData(@NotNull JsonObject object) {
        super(MMOUtils.backwardsCompatibleTriggerType(object.get("CastMode").getAsString()));
        this.ability = MMOItems.plugin.getSkills().getSkill(object.get("Id").getAsString());
        JsonObject modifiers = object.getAsJsonObject("Modifiers");
        modifiers.entrySet().forEach(entry -> this.setModifier((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsDouble()));
    }

    public AbilityData(@NotNull ConfigurationSection config) {
        super(MMOUtils.backwardsCompatibleTriggerType(UtilityMethods.enumName((String)Objects.requireNonNull(config.getString("mode"), "Ability is missing mode"))));
        Validate.isTrue((boolean)config.contains("type"), (String)"Ability is missing type");
        String abilityFormat = UtilityMethods.enumName((String)config.getString("type"));
        Validate.isTrue((boolean)MMOItems.plugin.getSkills().hasSkill(abilityFormat), (String)("Could not find ability called '" + abilityFormat + "'"));
        this.ability = MMOItems.plugin.getSkills().getSkill(abilityFormat);
        for (String key : config.getKeys(false)) {
            if (key.equalsIgnoreCase("mode") || key.equalsIgnoreCase("type") || !this.ability.getHandler().getModifiers().contains(key)) continue;
            this.modifiers.put(key, config.getDouble(key));
        }
    }

    public AbilityData(RegisteredSkill ability, TriggerType triggerType) {
        super(triggerType);
        this.ability = ability;
    }

    public RegisteredSkill getAbility() {
        return this.ability;
    }

    public Set<String> getModifiers() {
        return this.modifiers.keySet();
    }

    public void setModifier(String path, double value) {
        this.modifiers.put(path, value);
    }

    public boolean hasModifier(String path) {
        return this.modifiers.containsKey(path);
    }

    public boolean getResult(SkillMetadata meta) {
        PlayerData playerData = PlayerData.get((OfflinePlayer)meta.getCaster().getPlayer());
        RPGPlayer rpgPlayer = playerData.getRPG();
        Player player = meta.getCaster().getPlayer();
        if (meta.getCaster().getData().getCooldownMap().isOnCooldown((CooldownObject)this)) {
            CooldownInfo info = playerData.getMMOPlayerData().getCooldownMap().getInfo((CooldownObject)this);
            if (!this.getTrigger().isSilent()) {
                StringBuilder progressBar = new StringBuilder(ChatColor.YELLOW + "");
                double progress = (double)(info.getInitialCooldown() - info.getRemaining()) / (double)info.getInitialCooldown() * 10.0;
                String barChar = MMOItems.plugin.getConfig().getString("cooldown-progress-bar-char");
                for (int j = 0; j < 10; ++j) {
                    progressBar.append(progress >= (double)j ? ChatColor.GREEN : ChatColor.WHITE).append(barChar);
                }
                Message.SPELL_ON_COOLDOWN.format(ChatColor.RED, "#left#", MythicLib.plugin.getMMOConfig().decimal.format((double)info.getRemaining() / 1000.0), "#progress#", progressBar.toString(), "#s#", info.getRemaining() > 1999L ? "s" : "").send(player);
            }
            return false;
        }
        if (MMOItems.plugin.getConfig().getBoolean("permissions.abilities") && !player.hasPermission("mmoitems.ability." + this.getHandler().getLowerCaseId()) && !player.hasPermission("mmoitems.bypass.ability")) {
            return false;
        }
        if (this.hasModifier("mana") && rpgPlayer.getMana() < meta.getParameter("mana")) {
            Message.NOT_ENOUGH_MANA.format(ChatColor.RED, new String[0]).send(player);
            return false;
        }
        if (this.hasModifier("stamina") && rpgPlayer.getStamina() < meta.getParameter("stamina")) {
            Message.NOT_ENOUGH_STAMINA.format(ChatColor.RED, new String[0]).send(player);
            return false;
        }
        return true;
    }

    public void whenCast(SkillMetadata meta) {
        double cooldown;
        PlayerData playerData = PlayerData.get((OfflinePlayer)meta.getCaster().getPlayer());
        RPGPlayer rpgPlayer = playerData.getRPG();
        if (this.hasModifier("mana")) {
            rpgPlayer.giveMana(-meta.getParameter("mana"));
        }
        if (this.hasModifier("stamina")) {
            rpgPlayer.giveStamina(-meta.getParameter("stamina"));
        }
        if ((cooldown = meta.getParameter("cooldown") * (1.0 - Math.min(0.8, meta.getCaster().getStat("COOLDOWN_REDUCTION") / 100.0))) > 0.0) {
            meta.getCaster().getData().getCooldownMap().applyCooldown((CooldownObject)this, cooldown);
        }
    }

    public SkillHandler getHandler() {
        return this.ability.getHandler();
    }

    public double getParameter(String path) {
        return this.modifiers.getOrDefault(path, this.ability.getDefaultModifier(path));
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("Id", this.ability.getHandler().getId());
        object.addProperty("CastMode", this.getTrigger().name());
        JsonObject modifiers = new JsonObject();
        this.modifiers.keySet().forEach(modifier -> modifiers.addProperty(modifier, (Number)this.getParameter((String)modifier)));
        object.add("Modifiers", (JsonElement)modifiers);
        return object;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AbilityData that = (AbilityData)((Object)o);
        return this.ability.equals(that.ability) && this.getTrigger().equals((Object)that.getTrigger()) && this.modifiers.equals(that.modifiers);
    }

    public String toString() {
        return "AbilityData{ability=" + this.ability + ", modifiers=" + this.modifiers + '}';
    }

    public int hashCode() {
        return Objects.hash(this.ability, this.modifiers);
    }
}

