/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.gson.JsonParser;
import io.lumine.mythic.lib.gson.JsonSyntaxException;
import io.lumine.mythic.lib.version.Sounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.event.item.UpgradeItemEvent;
import net.Indyuce.mmoitems.api.interaction.Consumable;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.LiveMMOItem;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.api.item.mmoitem.VolatileMMOItem;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.gui.edition.UpgradingEdition;
import net.Indyuce.mmoitems.stat.data.UpgradeData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ConsumableItemInteraction;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeStat
extends ItemStat<UpgradeData, UpgradeData>
implements ConsumableItemInteraction {
    private static final Random RANDOM = new Random();

    public UpgradeStat() {
        super("UPGRADE", Material.FLINT, "Item Upgrading", new String[]{"Upgrading your item improves its", "current stats. It requires either a", "consumable or a specific crafting ", "station. Upgrading may sometimes &cfail&7..."}, new String[]{"equipment"}, new Material[0]);
    }

    @Override
    public UpgradeData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof ConfigurationSection), (String)"Must specify a config section");
        return new UpgradeData((ConfigurationSection)object);
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull UpgradeData data) {
        if (!(data instanceof UpgradeData)) {
            return;
        }
        item.addItemTag(this.getAppliedNBT(data));
        item.getLore().registerPlaceholder("upgrade_level", String.valueOf(data.getLevel()));
        if (data.getMaxUpgrades() > 0) {
            item.getLore().insert(this.getPath(), this.getGeneralStatFormat().replace("{value}", String.valueOf(data.getMaxUpgrades())));
        }
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull UpgradeData data) {
        ArrayList<ItemTag> ret = new ArrayList<ItemTag>();
        ret.add(new ItemTag(this.getNBTPath(), (Object)data.toString()));
        return ret;
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            new UpgradingEdition(inv.getPlayer(), inv.getEdited()).open(inv);
        }
        if (event.getAction() == InventoryAction.PICKUP_HALF && inv.getEditedSection().contains("upgrade")) {
            inv.getEditedSection().set("upgrade", null);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully reset the upgrading setup.");
        }
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        if (info[0].equals("ref")) {
            inv.getEditedSection().set("upgrade.reference", (Object)message);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Upgrading reference successfully changed to " + ChatColor.GOLD + message + ChatColor.GRAY + ".");
            return;
        }
        if (info[0].equals("max")) {
            int i = Integer.parseInt(message);
            inv.getEditedSection().set("upgrade.max", (Object)i);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Max upgrades successfully set to " + ChatColor.GOLD + i + ChatColor.GRAY + ".");
            return;
        }
        if (info[0].equals("min")) {
            int i = Integer.parseInt(message);
            inv.getEditedSection().set("upgrade.min", (Object)i);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Min level successfully set to " + ChatColor.GOLD + i + ChatColor.GRAY + ".");
            return;
        }
        if (info[0].equals("rate")) {
            double d = MMOUtils.parseDouble(message);
            inv.getEditedSection().set("upgrade.success", (Object)d);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Upgrading rate successfully set to " + ChatColor.GOLD + d + "%" + ChatColor.GRAY + ".");
            return;
        }
        Validate.isTrue((boolean)MMOItems.plugin.getUpgrades().hasTemplate(message), (String)("Could not find any upgrade template with ID '" + message + "'."));
        inv.getEditedSection().set("upgrade.template", (Object)message);
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Upgrading template successfully changed to " + ChatColor.GOLD + message + ChatColor.GRAY + ".");
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        StatData data;
        ArrayList<ItemTag> tags = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            tags.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING));
        }
        if ((data = this.getLoadedNBT((ArrayList)tags)) != null) {
            mmoitem.setData(this, data);
        }
    }

    @Override
    @Nullable
    public UpgradeData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag uTag = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (uTag != null) {
            try {
                return new UpgradeData(new JsonParser().parse((String)uTag.getValue()).getAsJsonObject());
            }
            catch (JsonSyntaxException | IllegalStateException throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<UpgradeData> statData) {
        lore.add(ChatColor.YELLOW + "\u25ba" + " Left click to setup upgrading.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to reset.");
    }

    @Override
    @NotNull
    public UpgradeData getClearStatData() {
        return new UpgradeData(null, null, false, false, 0, 0, 0.0);
    }

    @Override
    public boolean handleConsumableEffect(@NotNull InventoryClickEvent event, @NotNull PlayerData playerData, @NotNull Consumable consumable, @NotNull NBTItem target, Type targetType) {
        VolatileMMOItem mmoitem = consumable.getMMOItem();
        Player player = playerData.getPlayer();
        if (mmoitem.hasData(ItemStats.UPGRADE) && target.hasTag(ItemStats.UPGRADE.getNBTPath())) {
            if (target.getItem().getAmount() > 1) {
                Message.CANT_UPGRADED_STACK.format(ChatColor.RED, new String[0]).send(player);
                player.playSound(player.getLocation(), Sounds.ENTITY_VILLAGER_NO, 1.0f, 2.0f);
                return false;
            }
            LiveMMOItem targetMMO = new LiveMMOItem(target);
            UpgradeData targetSharpening = (UpgradeData)targetMMO.getData(ItemStats.UPGRADE);
            if (targetSharpening.isWorkbench()) {
                return false;
            }
            if (!targetSharpening.canLevelUp()) {
                Message.MAX_UPGRADES_HIT.format(ChatColor.RED, new String[0]).send(player);
                player.playSound(player.getLocation(), Sounds.ENTITY_VILLAGER_NO, 1.0f, 2.0f);
                return false;
            }
            UpgradeData consumableSharpening = (UpgradeData)mmoitem.getData(ItemStats.UPGRADE);
            if (!MMOUtils.checkReference(consumableSharpening.getReference(), targetSharpening.getReference())) {
                Message.WRONG_UPGRADE_REFERENCE.format(ChatColor.RED, new String[0]).send(player);
                player.playSound(player.getLocation(), Sounds.ENTITY_VILLAGER_NO, 1.0f, 2.0f);
                return false;
            }
            UpgradeItemEvent called = new UpgradeItemEvent(playerData, mmoitem, targetMMO, consumableSharpening, targetSharpening);
            Bukkit.getPluginManager().callEvent((Event)called);
            if (called.isCancelled()) {
                return false;
            }
            targetSharpening.upgrade(targetMMO);
            NBTItem result = targetMMO.newBuilder().buildNBT();
            if (MMOItems.plugin.getLanguage().upgradeRequirementsCheck && !playerData.getRPG().canUse(result, false)) {
                Message.UPGRADE_REQUIREMENT_SAFE_CHECK.format(ChatColor.RED, new String[0]).send(player);
                player.playSound(player.getLocation(), Sounds.ENTITY_VILLAGER_NO, 1.0f, 2.0f);
                return false;
            }
            if (RANDOM.nextDouble() > consumableSharpening.getSuccess() * targetSharpening.getSuccess()) {
                Message.UPGRADE_FAIL.format(ChatColor.RED, new String[0]).send(player);
                if (targetSharpening.destroysOnFail()) {
                    event.getCurrentItem().setAmount(0);
                }
                player.playSound(player.getLocation(), Sounds.ENTITY_ITEM_BREAK, 1.0f, 2.0f);
                return true;
            }
            Message.UPGRADE_SUCCESS.format(ChatColor.YELLOW, "#item#", MMOUtils.getDisplayName(event.getCurrentItem())).send(player);
            event.getCurrentItem().setItemMeta(result.toItem().getItemMeta());
            player.playSound(player.getLocation(), Sounds.ENTITY_PLAYER_LEVELUP, 1.0f, 2.0f);
            return true;
        }
        return false;
    }
}

