/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.gson.JsonParser;
import io.lumine.mythic.lib.gson.JsonSyntaxException;
import io.lumine.mythic.lib.version.Sounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.annotation.HasCategory;
import net.Indyuce.mmoitems.stat.data.SoulboundData;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.InternalStat;
import net.Indyuce.mmoitems.stat.type.ItemRestriction;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.NotImplementedException;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@HasCategory(cat="soulbound")
public class Soulbound
extends ItemStat<RandomStatData<SoulboundData>, SoulboundData>
implements InternalStat,
ItemRestriction {
    public Soulbound() {
        super("SOULBOUND", Material.ENDER_EYE, "Soulbound", new String[0], new String[0], new Material[0]);
    }

    @Override
    @Nullable
    public RandomStatData<SoulboundData> whenInitialized(Object object) {
        throw new NotImplementedException();
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        throw new NotImplementedException();
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        throw new NotImplementedException();
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<RandomStatData<SoulboundData>> statData) {
        throw new NotImplementedException();
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull SoulboundData data) {
        item.addItemTag(this.getAppliedNBT(data));
        String formattedLoreTag = Message.SOULBOUND_ITEM_LORE.getFormatted().replace("#player#", data.getName()).replace("#level#", MMOUtils.intToRoman(data.getLevel()));
        item.getLore().insert("soulbound", formattedLoreTag.split(Pattern.quote("//")));
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull SoulboundData data) {
        ArrayList<ItemTag> a = new ArrayList<ItemTag>();
        a.add(new ItemTag(this.getNBTPath(), (Object)data.toJson().toString()));
        return a;
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        StatData data;
        ArrayList<ItemTag> rTags = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            rTags.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING));
        }
        if ((data = this.getLoadedNBT((ArrayList)rTags)) != null) {
            mmoitem.setData(this, data);
        }
    }

    @Override
    @Nullable
    public SoulboundData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag tag = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (tag != null) {
            try {
                return new SoulboundData(new JsonParser().parse((String)tag.getValue()).getAsJsonObject());
            }
            catch (JsonSyntaxException | IllegalStateException throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    @NotNull
    public SoulboundData getClearStatData() {
        return new SoulboundData(UUID.fromString("df930b7b-a84d-4f76-90ac-33be6a5b6c88"), "gunging", 0);
    }

    @Override
    public boolean canUse(RPGPlayer player, NBTItem item, boolean message) {
        if (item.hasTag(ItemStats.SOULBOUND.getNBTPath()) && !item.getString(ItemStats.SOULBOUND.getNBTPath()).contains(player.getPlayer().getUniqueId().toString()) && !player.getPlayer().hasPermission("mmoitems.bypass.soulbound")) {
            if (message) {
                int level = new JsonParser().parse(item.getString(ItemStats.SOULBOUND.getNBTPath())).getAsJsonObject().get("Level").getAsInt();
                Message.SOULBOUND_RESTRICTION.format(ChatColor.RED, new String[0]).send(player.getPlayer());
                player.getPlayer().playSound(player.getPlayer().getLocation(), Sounds.ENTITY_VILLAGER_NO, 1.0f, 1.5f);
                player.getPlayer().damage(MMOItems.plugin.getLanguage().soulboundBaseDamage + (double)level * MMOItems.plugin.getLanguage().soulboundPerLvlDamage);
            }
            return false;
        }
        return true;
    }
}

