/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.version.Sounds;
import java.util.Random;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.event.item.ApplySoulboundEvent;
import net.Indyuce.mmoitems.api.interaction.Consumable;
import net.Indyuce.mmoitems.api.item.mmoitem.LiveMMOItem;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.api.item.mmoitem.VolatileMMOItem;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.stat.annotation.HasCategory;
import net.Indyuce.mmoitems.stat.data.SoulboundData;
import net.Indyuce.mmoitems.stat.type.ConsumableItemInteraction;
import net.Indyuce.mmoitems.stat.type.DoubleStat;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@HasCategory(cat="soulbound")
public class SoulbindingChance
extends DoubleStat
implements ConsumableItemInteraction {
    private static final Random random = new Random();

    public SoulbindingChance() {
        super("SOULBINDING_CHANCE", Material.ENDER_EYE, "Soulbinding Chance", new String[]{"Defines the chance your item has to", "link another item to your soul,", "preventing other players from using it."}, new String[]{"consumable"}, new Material[0]);
    }

    @Override
    public boolean handleConsumableEffect(@NotNull InventoryClickEvent event, @NotNull PlayerData playerData, @NotNull Consumable consumable, @NotNull NBTItem target, @Nullable Type targetType) {
        Player player = playerData.getPlayer();
        if (targetType == null) {
            return false;
        }
        double soulbindingChance = consumable.getNBTItem().getStat("SOULBINDING_CHANCE");
        if (soulbindingChance <= 0.0) {
            return false;
        }
        if (target.getItem().getAmount() > 1) {
            Message.CANT_BIND_STACKED.format(ChatColor.RED, new String[0]).send(player);
            return false;
        }
        ReadMMOItem targetMMO = new VolatileMMOItem(target);
        if (targetMMO.hasData(ItemStats.SOULBOUND)) {
            SoulboundData data = (SoulboundData)targetMMO.getData(ItemStats.SOULBOUND);
            Message.CANT_BIND_ITEM.format(ChatColor.RED, "#player#", data.getName(), "#level#", MMOUtils.intToRoman(data.getLevel())).send(player);
            return false;
        }
        if (random.nextDouble() < soulbindingChance / 100.0) {
            ApplySoulboundEvent called = new ApplySoulboundEvent(playerData, consumable.getMMOItem(), target);
            Bukkit.getPluginManager().callEvent((Event)called);
            if (called.isCancelled()) {
                return false;
            }
            int soulboundLevel = (int)Math.max(1.0, consumable.getNBTItem().getStat("SOULBOUND_LEVEL"));
            targetMMO = new LiveMMOItem(target);
            targetMMO.setData(ItemStats.SOULBOUND, new SoulboundData(player.getUniqueId(), player.getName(), soulboundLevel));
            target.getItem().setItemMeta(targetMMO.newBuilder().build().getItemMeta());
            Message.SUCCESSFULLY_BIND_ITEM.format(ChatColor.YELLOW, "#item#", MMOUtils.getDisplayName(target.getItem()), "#level#", MMOUtils.intToRoman(soulboundLevel)).send(player);
            player.playSound(player.getLocation(), Sounds.ENTITY_PLAYER_LEVELUP, 1.0f, 2.0f);
            return true;
        }
        Message.UNSUCCESSFUL_SOULBOUND.format(ChatColor.RED, new String[0]).send(player);
        player.playSound(player.getLocation(), Sounds.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
        return true;
    }
}

