/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.gui.edition.RevisionInventory;
import net.Indyuce.mmoitems.stat.data.DoubleData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.GemStoneStat;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RevisionID
extends ItemStat<NumericStatFormula, DoubleData>
implements GemStoneStat {
    public RevisionID() {
        super("REVISION_ID", Material.ITEM_FRAME, "Revision ID", new String[]{"The Revision ID is used to determine", "if an item is outdated or not. You", "should increase this whenever", "you make changes to your item!", "", "\u00a76The updater is smart and will apply", "\u00a76changes to the base stats of the item,", "\u00a76keeping gemstones intact (for example)."}, new String[0], new Material[0]);
    }

    @Override
    public NumericStatFormula whenInitialized(Object object) {
        if (object instanceof Integer) {
            return new NumericStatFormula(((Integer)object).intValue(), 0.0, 0.0, 0.0);
        }
        throw new IllegalArgumentException("Must specify a whole number");
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull DoubleData data) {
        item.addItemTag(this.getAppliedNBT(data));
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull DoubleData data) {
        ArrayList<ItemTag> ret = new ArrayList<ItemTag>();
        ret.add(new ItemTag(this.getNBTPath(), (Object)((int)data.getValue())));
        return ret;
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        new RevisionInventory(inv.getPlayer(), inv.getEdited()).open(inv);
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        StatData data;
        ArrayList<ItemTag> tags = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            tags.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.INTEGER));
        }
        if ((data = this.getLoadedNBT((ArrayList)tags)) != null) {
            mmoitem.setData(this, data);
        }
    }

    @Override
    @Nullable
    public DoubleData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag tag = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (tag != null) {
            return new DoubleData(((Integer)tag.getValue()).intValue());
        }
        return null;
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<NumericStatFormula> statData) {
        if (statData.isPresent()) {
            NumericStatFormula data = statData.get();
            lore.add(ChatColor.GRAY + "Current Revision ID: " + ChatColor.GREEN + (int)data.getBase());
        } else {
            lore.add(ChatColor.GRAY + "Current Revision ID: " + ChatColor.GREEN + "1");
        }
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Left click to increase this value.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to decrease this value.");
    }

    @Override
    @NotNull
    public DoubleData getClearStatData() {
        return new DoubleData(0.0);
    }
}

