/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.api.item.mmoitem.VolatileMMOItem;
import net.Indyuce.mmoitems.stat.data.DoubleData;
import net.Indyuce.mmoitems.stat.type.DoubleStat;
import net.Indyuce.mmoitems.stat.type.PlayerConsumable;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RestoreFood
extends DoubleStat
implements PlayerConsumable {
    public RestoreFood() {
        super("RESTORE_FOOD", Material.PORKCHOP, "Food Restoration", new String[]{"Food units given when consumed."}, new String[]{"consumable"}, new Material[0]);
    }

    @Override
    public void onConsume(@NotNull VolatileMMOItem mmo, @NotNull Player player, boolean vanillaEating) {
        if (!mmo.hasData(ItemStats.RESTORE_FOOD)) {
            return;
        }
        DoubleData d = (DoubleData)mmo.getData(ItemStats.RESTORE_FOOD);
        int actualValue = SilentNumbers.ceil((double)(d.getValue() - (double)(vanillaEating ? this.getFoodRestored(mmo.getNBT().getItem()) : 0)));
        if (actualValue != 0) {
            MMOUtils.feed(player, actualValue);
        }
    }

    private int getFoodRestored(ItemStack item) {
        try {
            return MythicLib.plugin.getVersion().getWrapper().getFoodRestored(item);
        }
        catch (Exception ignored) {
            return 0;
        }
    }
}

