/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.version.Sounds;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.stat.data.RequiredLevelData;
import net.Indyuce.mmoitems.stat.type.RequiredLevelStat;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;

public class RequiredLevel
extends RequiredLevelStat {
    public RequiredLevel() {
        super("LEVEL", Material.EXPERIENCE_BOTTLE, "Level", new String[]{"The level your item needs", "in order to be used."});
    }

    @Override
    public boolean canUse(RPGPlayer player, NBTItem item, boolean message) {
        int level = item.getInteger(this.getNBTPath());
        if (level <= 0) {
            return true;
        }
        if (player.getLevel() >= level || player.getPlayer().hasPermission("mmoitems.bypass.level")) {
            return true;
        }
        if (message) {
            Message.NOT_ENOUGH_LEVELS.format(ChatColor.RED, new String[0]).send(player.getPlayer());
            player.getPlayer().playSound(player.getPlayer().getLocation(), Sounds.ENTITY_VILLAGER_NO, 1.0f, 1.5f);
        }
        return false;
    }

    @Override
    @NotNull
    public RequiredLevelData getClearStatData() {
        return new RequiredLevelData(0.0);
    }
}

