/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.ItemTag;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.stat.data.DoubleData;
import net.Indyuce.mmoitems.stat.type.DoubleStat;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;

public class PickaxePower
extends DoubleStat {
    public PickaxePower() {
        super("PICKAXE_POWER", Material.IRON_PICKAXE, "Pickaxe Power", new String[]{"The breaking strength of the", "item when mining custom blocks."}, new String[]{"tool"}, new Material[0]);
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull DoubleData data) {
        int pickPower = (int)data.getValue();
        item.addItemTag(new ItemTag("MMOITEMS_PICKAXE_POWER", (Object)pickPower));
        item.getLore().insert("pickaxe-power", DoubleStat.formatPath(this.getPath(), this.getGeneralStatFormat(), true, false, (double)pickPower));
    }

    @Override
    public void whenPreviewed(@NotNull ItemStackBuilder item, @NotNull DoubleData currentData, @NotNull NumericStatFormula templateData) throws IllegalArgumentException {
        Validate.isTrue((boolean)(currentData instanceof DoubleData), (String)"Current Data is not Double Data");
        Validate.isTrue((boolean)(templateData instanceof NumericStatFormula), (String)"Template Data is not Numeric Stat Formula");
        double techMinimum = templateData.calculate(0.0, NumericStatFormula.FormulaInputType.LOWER_BOUND);
        double techMaximum = templateData.calculate(0.0, NumericStatFormula.FormulaInputType.UPPER_BOUND);
        if (techMaximum < 0.0 && !this.handleNegativeStats()) {
            return;
        }
        if (techMinimum < 0.0 && !this.handleNegativeStats()) {
            techMinimum = 0.0;
        }
        if (techMinimum < templateData.getBase() - templateData.getMaxSpread()) {
            techMinimum = templateData.getBase() - templateData.getMaxSpread();
        }
        if (techMaximum > templateData.getBase() + templateData.getMaxSpread()) {
            techMaximum = templateData.getBase() + templateData.getMaxSpread();
        }
        item.addItemTag(new ItemTag("MMOITEMS_PICKAXE_POWER", (Object)currentData.getValue()));
        if (techMinimum != 0.0 || techMaximum != 0.0) {
            String builtRange = DoubleStat.formatPath(this.getPath(), this.getGeneralStatFormat(), true, false, Math.floor(techMinimum), Math.floor(techMaximum));
            item.getLore().insert("pickaxe-power", builtRange);
        }
    }
}

