/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.version.Sounds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.StringListData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemRestriction;
import net.Indyuce.mmoitems.stat.type.StringListStat;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Permission
extends StringListStat
implements ItemRestriction {
    public Permission() {
        super("PERMISSION", Material.OAK_SIGN, "Permission", new String[]{"The permission needed to use this item."}, new String[]{"!block", "all"}, new Material[0]);
    }

    @Override
    public StringListData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof List), (String)"Must specify a string list");
        return new StringListData((List)object);
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            new StatEdition(inv, ItemStats.PERMISSION, new Object[0]).enable("Write in the chat the permission you want your item to require.");
        }
        if (event.getAction() == InventoryAction.PICKUP_HALF && inv.getEditedSection().contains("permission")) {
            List requiredPerms = inv.getEditedSection().getStringList("permission");
            if (requiredPerms.size() < 1) {
                return;
            }
            String last = (String)requiredPerms.get(requiredPerms.size() - 1);
            requiredPerms.remove(last);
            inv.getEditedSection().set("permission", (Object)(requiredPerms.size() == 0 ? null : requiredPerms));
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully removed " + last + ".");
        }
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        Validate.isTrue((!message.contains("|") ? 1 : 0) != 0, (String)"Your perm node must not contain any | symbol.");
        List<String> lore = inv.getEditedSection().contains("permission") ? inv.getEditedSection().getStringList("permission") : new ArrayList();
        lore.add(message);
        inv.getEditedSection().set("permission", lore);
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Permission successfully added.");
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<StringListData> statData) {
        if (statData.isPresent()) {
            lore.add(ChatColor.GRAY + "Current Value:");
            StringListData data = statData.get();
            data.getList().forEach(el -> lore.add(ChatColor.GRAY + "* " + ChatColor.GREEN + el));
        } else {
            lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.RED + "None");
        }
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Click to add a compatible permission.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove the last permission.");
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull StringListData data) {
        ArrayList<ItemTag> ret = new ArrayList<ItemTag>();
        ret.add(new ItemTag(this.getNBTPath(), (Object)String.join((CharSequence)"|", data.getList())));
        return ret;
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        StatData data;
        ArrayList<ItemTag> revTgs = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            revTgs.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING));
        }
        if ((data = this.getLoadedNBT((ArrayList)revTgs)) != null) {
            mmoitem.setData(this, data);
        }
    }

    @Override
    @Nullable
    public StringListData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag encoded = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (encoded != null) {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(((String)encoded.getValue()).split("\\|")));
            return new StringListData(list);
        }
        return null;
    }

    @Override
    public boolean canUse(RPGPlayer player, NBTItem item, boolean message) {
        String perm = item.getString("MMOITEMS_PERMISSION");
        if (!perm.equals("") && !player.getPlayer().hasPermission("mmoitems.bypass.item") && MMOItems.plugin.getConfig().getBoolean("permissions.items")) {
            String[] split;
            for (String s : split = perm.split("\\|")) {
                if (player.getPlayer().hasPermission(s)) continue;
                if (message) {
                    Message.NOT_ENOUGH_PERMS.format(ChatColor.RED, new String[0]).send(player.getPlayer());
                    player.getPlayer().playSound(player.getPlayer().getLocation(), Sounds.ENTITY_VILLAGER_NO, 1.0f, 1.5f);
                }
                return false;
            }
        }
        return true;
    }
}

