/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.gson.JsonElement;
import io.lumine.mythic.lib.gson.JsonObject;
import io.lumine.mythic.lib.gson.JsonParser;
import io.lumine.mythic.lib.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.PotionEffectData;
import net.Indyuce.mmoitems.stat.data.PotionEffectListData;
import net.Indyuce.mmoitems.stat.data.random.RandomPotionEffectData;
import net.Indyuce.mmoitems.stat.data.random.RandomPotionEffectListData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermanentEffects
extends ItemStat<RandomPotionEffectListData, PotionEffectListData> {
    public PermanentEffects() {
        super("PERM_EFFECTS", Material.POTION, "Permanent Effects", new String[]{"The potion effects your", "item grants to the holder."}, new String[]{"!miscellaneous", "!block", "all"}, new Material[0]);
    }

    @Override
    public RandomPotionEffectListData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof ConfigurationSection), (String)"Must specify a config section");
        ConfigurationSection config = (ConfigurationSection)object;
        RandomPotionEffectListData effects = new RandomPotionEffectListData(new RandomPotionEffectData[0]);
        for (String effect : config.getKeys(false)) {
            PotionEffectType type = PotionEffectType.getByName((String)effect.toUpperCase().replace("-", "_").replace(" ", "_"));
            Validate.notNull((Object)type, (String)("Could not find potion effect type named '" + effect + "'"));
            effects.add(new RandomPotionEffectData(type, new NumericStatFormula(config.get(effect))));
        }
        return effects;
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            new StatEdition(inv, ItemStats.PERM_EFFECTS, new Object[0]).enable("Write in the chat the permanent potion effect you want to add.", ChatColor.AQUA + "Format: {Effect Name} {Amplifier Numeric Formula}");
        }
        if (event.getAction() == InventoryAction.PICKUP_HALF && inv.getEditedSection().contains("perm-effects")) {
            Set set = inv.getEditedSection().getConfigurationSection("perm-effects").getKeys(false);
            String last = (String)new ArrayList(set).get(set.size() - 1);
            inv.getEditedSection().set("perm-effects." + last, null);
            if (set.size() <= 1) {
                inv.getEditedSection().set("perm-effects", null);
            }
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully removed " + last.substring(0, 1).toUpperCase() + last.substring(1).toLowerCase() + ".");
        }
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        String[] split = message.split(" ");
        Validate.isTrue((split.length >= 2 ? 1 : 0) != 0, (String)"Use this format: {Effect Name} {Effect Amplifier Numeric Formula}. Example: 'speed 1 0.3' stands for Speed 1, plus 0.3 level per item level (rounded up to lower int)");
        PotionEffectType effect = PotionEffectType.getByName((String)split[0].replace("-", "_"));
        Validate.notNull((Object)effect, (String)(split[0] + " is not a valid potion effect. All potion effects can be found here: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/potion/PotionEffectType.html"));
        NumericStatFormula formula = new NumericStatFormula(message.substring(message.indexOf(" ") + 1));
        formula.fillConfigurationSection(inv.getEditedSection(), "perm-effects." + effect.getName());
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + ChatColor.GOLD + effect.getName() + " " + formula + ChatColor.GRAY + " successfully added.");
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<RandomPotionEffectListData> statData) {
        if (statData.isPresent()) {
            lore.add(ChatColor.GRAY + "Current Value:");
            RandomPotionEffectListData data = statData.get();
            for (RandomPotionEffectData effect : data.getEffects()) {
                lore.add(ChatColor.GRAY + "* " + ChatColor.GREEN + UtilityMethods.caseOnWords((String)effect.getType().getName().replace("_", " ").toLowerCase()) + " " + effect.getAmplifier().toString());
            }
        } else {
            lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.RED + "None");
        }
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Click to add an effect.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove the last effect.");
    }

    @Override
    @NotNull
    public PotionEffectListData getClearStatData() {
        return new PotionEffectListData(new PotionEffectData[0]);
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull PotionEffectListData data) {
        ArrayList<String> lore = new ArrayList<String>();
        String permEffectFormat = this.getGeneralStatFormat();
        data.getEffects().forEach(effect -> lore.add(permEffectFormat.replace("{effect}", MMOItems.plugin.getLanguage().getPotionEffectName(effect.getType()) + " " + MMOUtils.intToRoman(effect.getLevel()))));
        item.getLore().insert("perm-effects", lore);
        item.addItemTag(this.getAppliedNBT(data));
    }

    @Override
    public String getLegacyTranslationPath() {
        return "perm-effect";
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull PotionEffectListData data) {
        ArrayList<ItemTag> ret = new ArrayList<ItemTag>();
        JsonObject object = new JsonObject();
        for (PotionEffectData effect : data.getEffects()) {
            object.addProperty(effect.getType().getName(), (Number)effect.getLevel());
        }
        ret.add(new ItemTag(this.getNBTPath(), (Object)object.toString()));
        return ret;
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        StatData data;
        ArrayList<ItemTag> rTag = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            rTag.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING));
        }
        if ((data = this.getLoadedNBT((ArrayList)rTag)) != null) {
            mmoitem.setData(this, data);
        }
    }

    @Override
    @Nullable
    public PotionEffectListData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag oTag = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (oTag != null) {
            try {
                PotionEffectListData effects = new PotionEffectListData(new PotionEffectData[0]);
                JsonElement element = new JsonParser().parse((String)oTag.getValue());
                element.getAsJsonObject().entrySet().forEach(entry -> effects.add(new PotionEffectData(PotionEffectType.getByName((String)((String)entry.getKey())), ((JsonElement)entry.getValue()).getAsInt())));
                return effects;
            }
            catch (JsonSyntaxException | IllegalStateException throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

