/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.util.EnumUtils;
import io.lumine.mythic.lib.version.VMaterial;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.MaterialData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaterialStat
extends ItemStat<MaterialData, MaterialData> {
    public MaterialStat() {
        super("MATERIAL", VMaterial.GRASS_BLOCK.get(), "Material", new String[]{"Your item material."}, new String[0], new Material[0]);
    }

    @Override
    public MaterialData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof String), (String)"Must specify material name as string");
        return new MaterialData(Material.valueOf((String)((String)object).toUpperCase().replace("-", "_").replace(" ", "_")));
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        new StatEdition(inv, ItemStats.MATERIAL, new Object[0]).enable("Write in the chat the material you want.");
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        Optional material = EnumUtils.getIfPresent(Material.class, (String)message.toUpperCase().replace("-", "_").replace(" ", "_"));
        if (material.isPresent()) {
            inv.getEditedSection().set("material", (Object)((Material)material.get()).name());
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Material successfully changed to " + ((Material)material.get()).name() + ".");
        } else {
            inv.getPlayer().spigot().sendMessage(new ComponentBuilder("Invalid material! (Click for a list of valid materials)").color(ChatColor.RED).event(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Material.html")).create());
        }
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull MaterialData data) {
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        mmoitem.setData(this, new MaterialData(mmoitem.getNBT().getItem().getType()));
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<MaterialData> statData) {
        lore.add(ChatColor.GRAY + "Current Value: " + (statData.isPresent() ? ChatColor.GREEN + UtilityMethods.caseOnWords((String)statData.get().getMaterial().name().toLowerCase().replace("_", " ")) : ChatColor.RED + "None"));
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Left click to change this value.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove this value.");
    }

    @Override
    @NotNull
    public MaterialData getClearStatData() {
        return new MaterialData(Material.IRON_ORE);
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull MaterialData data) {
        return new ArrayList<ItemTag>();
    }

    @Override
    @Nullable
    public MaterialData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        return null;
    }
}

