/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.StringListData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemTypeRestriction
extends ItemStat<StringListData, StringListData> {
    public ItemTypeRestriction() {
        super("ITEM_TYPE_RESTRICTION", Material.EMERALD, "Item Type Restriction", new String[]{"This option defines the item types", "on which your gem can be applied."}, new String[]{"gem_stone"}, new Material[0]);
    }

    @Override
    public StringListData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof List), (String)"Must specify a string list");
        return new StringListData((List)object);
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            new StatEdition(inv, ItemStats.ITEM_TYPE_RESTRICTION, new Object[0]).enable("Write in the chat the item type you want your gem to support.", "Supported formats: WEAPON or BLUNT, PIERCING, SLASHING, OFFHAND, EXTRA.");
        }
        if (event.getAction() == InventoryAction.PICKUP_HALF && inv.getEditedSection().contains(this.getPath())) {
            List list = inv.getEditedSection().getStringList("" + this.getPath());
            if (list.size() < 1) {
                return;
            }
            String last = (String)list.get(list.size() - 1);
            list.remove(last);
            inv.getEditedSection().set("" + this.getPath(), (Object)(list.size() == 0 ? null : list));
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully removed " + last + ".");
        }
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        String format = message.toUpperCase().replace(" ", "_").replace("-", "_");
        Validate.isTrue((boolean)this.isValid(format), (String)(format + " is not a valid item type/set. You can enter WEAPON, BLUNT, PIERCING, SLASHING, OFFHAND, EXTRA, as well as other item types here: /mi list type."));
        ArrayList<String> list = inv.getEditedSection().contains(this.getPath()) ? inv.getEditedSection().getStringList("" + this.getPath()) : new ArrayList<String>();
        list.add(format);
        inv.getEditedSection().set(this.getPath(), list);
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Your gem now supports " + format + ".");
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<StringListData> statData) {
        if (statData.isPresent()) {
            lore.add(ChatColor.GRAY + "Current Value:");
            StringListData data = statData.get();
            data.getList().forEach(el -> lore.add(ChatColor.GRAY + "* " + ChatColor.GREEN + el));
        } else {
            lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.RED + "Compatible with any type.");
        }
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Click to add a supported item type/set.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove the last element.");
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull StringListData data) {
        item.addItemTag(this.getAppliedNBT(data));
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull StringListData data) {
        ArrayList<ItemTag> ret = new ArrayList<ItemTag>();
        String joined = String.join((CharSequence)",", data.getList());
        ret.add(new ItemTag(this.getNBTPath(), (Object)joined));
        return ret;
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        StatData bakedData;
        ArrayList<ItemTag> relevantTags = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            relevantTags.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING));
        }
        if ((bakedData = this.getLoadedNBT((ArrayList)relevantTags)) != null) {
            mmoitem.setData(this, bakedData);
        }
    }

    @Override
    @Nullable
    public StringListData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag tg = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (tg != null) {
            String value = (String)tg.getValue();
            ArrayList<String> tag = new ArrayList<String>();
            if (value.contains(",")) {
                for (String t : value.split(",")) {
                    if (t.isEmpty()) continue;
                    tag.add(t);
                }
            } else {
                tag.add(value);
            }
            return new StringListData(tag);
        }
        return null;
    }

    private boolean isValid(String format) {
        if (format.equals("WEAPON")) {
            return true;
        }
        for (Type type : MMOItems.plugin.getTypes().getAll()) {
            if (!type.getId().equals(format)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public StringListData getClearStatData() {
        return new StringListData();
    }
}

