/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.gson.JsonParser;
import io.lumine.mythic.lib.gson.JsonSyntaxException;
import io.lumine.mythic.lib.version.VParticle;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.gui.edition.ParticlesEdition;
import net.Indyuce.mmoitems.particle.api.ParticleType;
import net.Indyuce.mmoitems.stat.data.ParticleData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemParticles
extends ItemStat<ParticleData, ParticleData> {
    public ItemParticles() {
        super("ITEM_PARTICLES", Material.PINK_STAINED_GLASS, "Item Particles", new String[]{"The particles displayed when", "holding/wearing your item.", "", ChatColor.BLUE + "A tutorial is available on the wiki."}, new String[]{"all", "!block"}, new Material[0]);
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_HALF) {
            inv.getEditedSection().set(this.getPath(), null);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully removed " + this.getName() + ChatColor.GRAY + ".");
            return;
        }
        new ParticlesEdition(inv.getPlayer(), inv.getEdited()).open(inv);
    }

    @Override
    public ParticleData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof ConfigurationSection), (String)"Must specify a config section");
        return new ParticleData((ConfigurationSection)object);
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull ParticleData data) {
        item.addItemTag(this.getAppliedNBT(data));
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull ParticleData data) {
        ArrayList<ItemTag> ret = new ArrayList<ItemTag>();
        ret.add(new ItemTag(this.getNBTPath(), (Object)data.toJson().toString()));
        return ret;
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<ParticleData> statData) {
        lore.add(ChatColor.YELLOW + "\u25ba" + " Left click to setup the item particles.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to clear.");
    }

    @Override
    @NotNull
    public ParticleData getClearStatData() {
        return new ParticleData(ParticleType.AURA, VParticle.LARGE_EXPLOSION.get());
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        String edited = (String)info[0];
        String format = message.toUpperCase().replace("-", "_").replace(" ", "_");
        if (edited.equals("particle-type")) {
            ParticleType particleType = ParticleType.valueOf(format);
            inv.getEditedSection().set("item-particles.type", (Object)particleType.name());
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Particle type successfully set to " + ChatColor.GOLD + particleType.getDefaultName() + ChatColor.GRAY + ".");
            return;
        }
        if (edited.equals("particle-color")) {
            String[] split = message.split(" ");
            int red = Integer.parseInt(split[0]);
            int green = Integer.parseInt(split[1]);
            int blue = Integer.parseInt(split[2]);
            inv.getEditedSection().set("item-particles.color.red", (Object)red);
            inv.getEditedSection().set("item-particles.color.green", (Object)green);
            inv.getEditedSection().set("item-particles.color.blue", (Object)blue);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Particle color successfully set to " + ChatColor.RED + ChatColor.BOLD + red + ChatColor.GRAY + " - " + ChatColor.GREEN + ChatColor.BOLD + green + ChatColor.GRAY + " - " + ChatColor.BLUE + ChatColor.BOLD + blue + ChatColor.GRAY + ".");
            return;
        }
        if (edited.equals("particle")) {
            Particle particle = Particle.valueOf((String)format);
            inv.getEditedSection().set("item-particles.particle", (Object)particle.name());
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Particle successfully set to " + ChatColor.GOLD + UtilityMethods.caseOnWords((String)particle.name().toLowerCase().replace("_", " ")) + ChatColor.GRAY + ".");
            return;
        }
        double value = MMOUtils.parseDouble(message);
        inv.getEditedSection().set("item-particles." + edited, (Object)value);
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + ChatColor.GOLD + UtilityMethods.caseOnWords((String)edited.replace("-", " ")) + ChatColor.GRAY + " set to " + ChatColor.GOLD + value + ChatColor.GRAY + ".");
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        StatData data;
        ArrayList<ItemTag> tags = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            tags.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING));
        }
        if ((data = this.getLoadedNBT((ArrayList)tags)) != null) {
            mmoitem.setData(this, data);
        }
    }

    @Override
    @Nullable
    public ParticleData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag tagg = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (tagg != null) {
            try {
                return new ParticleData(new JsonParser().parse((String)tagg.getValue()).getAsJsonObject());
            }
            catch (JsonSyntaxException | IllegalStateException throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

