/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.gson.JsonArray;
import io.lumine.mythic.lib.gson.JsonObject;
import io.lumine.mythic.lib.gson.JsonParser;
import io.lumine.mythic.lib.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.DisplayName;
import net.Indyuce.mmoitems.stat.data.GemSocketsData;
import net.Indyuce.mmoitems.stat.data.GemstoneData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GemSockets
extends ItemStat<GemSocketsData, GemSocketsData> {
    private String emptyGemSocketFormat;
    private String filledGemSocketFormat;

    public GemSockets() {
        super("GEM_SOCKETS", Material.EMERALD, "Gem Sockets", new String[]{"The amount of gem", "sockets your weapon has."}, new String[]{"!gem_stone", "equipment", "ornament"}, new Material[0]);
    }

    @Override
    public GemSocketsData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof List), (String)"Must specify a string list");
        return new GemSocketsData((List)object);
    }

    @Override
    public void loadConfiguration(@NotNull ConfigurationSection legacyLanguageFile, @NotNull Object configObject) {
        if (configObject instanceof String) {
            this.emptyGemSocketFormat = legacyLanguageFile.getString("empty-gem-socket");
            this.filledGemSocketFormat = legacyLanguageFile.getString("filled-gem-socket");
        } else {
            Validate.isTrue((boolean)(configObject instanceof ConfigurationSection), (String)"Must be a config section");
            ConfigurationSection config = (ConfigurationSection)configObject;
            this.emptyGemSocketFormat = config.getString("empty");
            this.filledGemSocketFormat = config.getString("filled");
        }
    }

    @Override
    public String getLegacyTranslationPath() {
        return "empty-gem-socket";
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull GemSocketsData sockets) {
        item.addItemTag(this.getAppliedNBT(sockets));
        ArrayList<String> lore = new ArrayList<String>();
        for (GemstoneData gem : sockets.getGemstones()) {
            Integer gLvl;
            int iLvl;
            String gemName = gem.getName();
            if (item.getMMOItem().hasUpgradeTemplate() && (iLvl = item.getMMOItem().getUpgradeLevel()) != 0 && (gLvl = gem.getLevel()) != null) {
                int dLevel = iLvl - gLvl;
                gemName = DisplayName.appendUpgradeLevel(gemName, dLevel);
            }
            lore.add(this.filledGemSocketFormat.replace("{name}", gemName));
        }
        sockets.getEmptySlots().forEach(slot -> lore.add(this.emptyGemSocketFormat.replace("{name}", (CharSequence)slot)));
        item.getLore().insert("gem-stones", lore);
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull GemSocketsData sockets) {
        ArrayList<ItemTag> ret = new ArrayList<ItemTag>();
        ret.add(new ItemTag(this.getNBTPath(), (Object)sockets.toJson().toString()));
        return ret;
    }

    @Override
    @NotNull
    public String getNBTPath() {
        return "MMOITEMS_GEM_STONES";
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        StatData data;
        ArrayList<ItemTag> relevantTags = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            relevantTags.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING));
        }
        if ((data = this.getLoadedNBT((ArrayList)relevantTags)) != null) {
            mmoitem.setData(this, data);
        }
    }

    @Override
    @Nullable
    public GemSocketsData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag gTag = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (gTag != null) {
            try {
                JsonObject object = new JsonParser().parse((String)gTag.getValue()).getAsJsonObject();
                GemSocketsData sockets = new GemSocketsData(object.getAsJsonArray("EmptySlots"));
                JsonArray array = object.getAsJsonArray("Gemstones");
                array.forEach(element -> sockets.add(new GemstoneData(element.getAsJsonObject())));
                return sockets;
            }
            catch (JsonSyntaxException | IllegalStateException throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            new StatEdition(inv, ItemStats.GEM_SOCKETS, new Object[0]).enable("Write in the chat the COLOR of the gem socket you want to add.");
        }
        if (event.getAction() == InventoryAction.PICKUP_HALF && inv.getEditedSection().contains(this.getPath())) {
            List lore = inv.getEditedSection().getStringList("" + this.getPath());
            if (lore.size() < 1) {
                return;
            }
            String last = (String)lore.get(lore.size() - 1);
            lore.remove(last);
            inv.getEditedSection().set("" + this.getPath(), (Object)lore);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully removed '" + last + ChatColor.GRAY + "'.");
        }
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        ArrayList<String> lore = inv.getEditedSection().contains(this.getPath()) ? inv.getEditedSection().getStringList("" + this.getPath()) : new ArrayList<String>();
        lore.add(message);
        inv.getEditedSection().set("" + this.getPath(), lore);
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + message + " successfully added.");
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<GemSocketsData> statData) {
        if (statData.isPresent()) {
            lore.add(ChatColor.GRAY + "Current Value:");
            GemSocketsData data = statData.get();
            data.getEmptySlots().forEach(socket -> lore.add(ChatColor.GRAY + "* " + ChatColor.GREEN + socket + " Gem Socket"));
        } else {
            lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.RED + "No Sockets");
        }
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Click to add a gem socket.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove the socket.");
    }

    @Override
    @NotNull
    public GemSocketsData getClearStatData() {
        return new GemSocketsData(new ArrayList<String>());
    }
}

