/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.comp.adventure.AdventureParser;
import java.util.ArrayList;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ItemTier;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.stat.data.StringData;
import net.Indyuce.mmoitems.stat.type.GemStoneStat;
import net.Indyuce.mmoitems.stat.type.NameData;
import net.Indyuce.mmoitems.stat.type.StatHistory;
import net.Indyuce.mmoitems.stat.type.StringStat;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayName
extends StringStat
implements GemStoneStat {
    public DisplayName() {
        super("NAME", Material.NAME_TAG, "Display Name", new String[]{"The item display name."}, new String[0], new Material[0]);
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull StringData data) {
        item.getMMOItem().computeStatHistory(this);
        ItemTier tier = item.getMMOItem().getTier();
        AdventureParser parser = MythicLib.plugin.getAdventureParser();
        String format = data.toString();
        format = format.replace("<tier-name>", tier != null ? parser.stripColors(tier.getUnparsedName()) : "").replace("<tier-color>", tier != null ? parser.lastColor(tier.getUnparsedName(), true) : "&f").replace("<tier-color-cleaned>", tier != null ? parser.lastColor(tier.getUnparsedName(), false) : "");
        format = this.cropUpgrade(format);
        if (item.getMMOItem().hasUpgradeTemplate()) {
            format = DisplayName.appendUpgradeLevel(format, item.getMMOItem().getUpgradeLevel());
        }
        item.getMeta().setDisplayName(format);
        item.addItemTag(this.getAppliedNBT(data));
    }

    @NotNull
    String cropUpgrade(@NotNull String format) {
        String afterPrefix;
        String beforePrefix;
        int aFt_offset;
        int sB4_offset;
        String suffix = MMOItems.plugin.getConfig().getString("item-upgrading.name-suffix", " &8(&e+#lvl#&8)");
        if (suffix == null || suffix.isEmpty()) {
            return format;
        }
        int lvlOFFSET = suffix.indexOf("#lvl#");
        if (lvlOFFSET < 0) {
            return format;
        }
        String sB4 = suffix.substring(0, lvlOFFSET);
        String aFt = suffix.substring(lvlOFFSET + "#lvl#".length());
        String sB4_alt = sB4.replace("+", "-");
        String aFt_alt = aFt.replace("+", "-");
        if (format.contains(sB4)) {
            sB4_offset = format.indexOf(sB4);
            aFt_offset = format.lastIndexOf(aFt);
            aFt_offset = aFt_offset < 0 ? format.length() : (aFt_offset += aFt.length());
            beforePrefix = format.substring(0, sB4_offset);
            afterPrefix = format.substring(aFt_offset);
            format = beforePrefix + afterPrefix;
        }
        if (format.contains(sB4_alt)) {
            sB4_offset = format.indexOf(sB4_alt);
            aFt_offset = format.lastIndexOf(aFt_alt);
            aFt_offset = aFt_offset < 0 ? format.length() : (aFt_offset += aFt_alt.length());
            beforePrefix = format.substring(0, sB4_offset);
            afterPrefix = format.substring(aFt_offset);
            format = beforePrefix + afterPrefix;
        }
        return format;
    }

    @NotNull
    public static String appendUpgradeLevel(@NotNull String format, int lvl) {
        String suffix = MMOItems.plugin.getConfig().getString("item-upgrading.name-suffix");
        if (suffix != null && lvl != 0) {
            String actSuffix = DisplayName.levelPrefix(suffix, lvl);
            return format + actSuffix;
        }
        return format;
    }

    @NotNull
    public static String levelPrefix(@NotNull String template, int toLevel) {
        return template.replace("#lvl#", String.valueOf(toLevel)).replace("+-", "-");
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull StringData stringData) {
        Validate.isTrue((boolean)(stringData instanceof NameData), (String)"Data is not name data");
        NameData data = (NameData)stringData;
        ArrayList<ItemTag> tags = new ArrayList<ItemTag>();
        tags.add(new ItemTag(this.getNBTPath(), (Object)data.getMainName()));
        if (data.hasPrefixes()) {
            tags.add(data.compressPrefixes(this.getNBTPath() + "_PRE"));
        }
        if (data.hasSuffixes()) {
            tags.add(data.compressSuffixes(this.getNBTPath() + "_SUF"));
        }
        return tags;
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        ArrayList<ItemTag> relevantTags = new ArrayList<ItemTag>();
        boolean stored = false;
        ItemTag mainName = ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING);
        if (mainName != null) {
            ItemTag prefixes = ItemTag.getTagAtPath((String)(this.getNBTPath() + "_PRE"), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING);
            ItemTag suffixes = ItemTag.getTagAtPath((String)(this.getNBTPath() + "_SUF"), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING);
            relevantTags.add(mainName);
            relevantTags.add(prefixes);
            relevantTags.add(suffixes);
            if (mmoitem.getNBT().getItem().getItemMeta().hasDisplayName()) {
                stored = true;
            }
        } else {
            if (!mmoitem.getNBT().getItem().getItemMeta().hasDisplayName()) {
                return;
            }
            relevantTags.add(new ItemTag(this.getNBTPath(), (Object)this.cropUpgrade(mmoitem.getNBT().getItem().getItemMeta().getDisplayName())));
        }
        NameData bakedData = (NameData)this.getLoadedNBT((ArrayList)relevantTags);
        if (bakedData != null) {
            StatHistory hist;
            ItemTag hisTag;
            String itemName = null;
            if (stored) {
                String colorless;
                itemName = mmoitem.getNBT().getItem().getItemMeta().getDisplayName();
                if (!itemName.equals(colorless = ChatColor.stripColor((String)itemName))) {
                    itemName = null;
                } else {
                    bakedData.setString(itemName);
                }
            }
            mmoitem.setData(this, bakedData);
            if (stored && itemName != null && !mmoitem.hasStatHistory(this) && (hisTag = ItemTag.getTagAtPath((String)("HSTRY_" + this.getId()), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING)) != null && (hist = StatHistory.fromNBTString(mmoitem, (String)hisTag.getValue())) != null) {
                NameData og = (NameData)hist.getOriginalData();
                og.setString(itemName);
                mmoitem.setStatHistory(this, hist);
            }
        }
    }

    @Override
    @Nullable
    public StringData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag tg = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (tg != null) {
            String value = (String)tg.getValue();
            NameData nd = new NameData(value);
            nd.readPrefixes(ItemTag.getTagAtPath((String)(this.getNBTPath() + "_PRE"), storedTags));
            nd.readSuffixes(ItemTag.getTagAtPath((String)(this.getNBTPath() + "_SUF"), storedTags));
            return nd;
        }
        return null;
    }

    @Override
    @NotNull
    public StringData getClearStatData() {
        return new NameData(null);
    }

    @Override
    public StringData whenInitialized(Object object) {
        return new NameData(object.toString());
    }
}

