/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.version.Sounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.CustomSound;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.api.item.mmoitem.VolatileMMOItem;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.gui.edition.SoundsEdition;
import net.Indyuce.mmoitems.stat.data.SoundData;
import net.Indyuce.mmoitems.stat.data.SoundListData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.GemStoneStat;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.stat.type.PlayerConsumable;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomSounds
extends ItemStat<SoundListData, SoundListData>
implements GemStoneStat,
PlayerConsumable {
    public CustomSounds() {
        super("SOUNDS", Material.JUKEBOX, "Custom Sounds", new String[]{"The custom sounds your item will use."}, new String[0], new Material[0]);
    }

    @Override
    public SoundListData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof ConfigurationSection), (String)"Must specify a config section");
        ConfigurationSection config = (ConfigurationSection)object;
        SoundListData sounds = new SoundListData();
        for (CustomSound sound : CustomSound.values()) {
            String path = sound.name().replace("_", "-").toLowerCase();
            if (!config.contains(path)) continue;
            sounds.set(sound, new SoundData(config.get(path)));
        }
        return sounds;
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            new SoundsEdition(inv.getPlayer(), inv.getEdited()).open(inv);
        }
        if (event.getAction() == InventoryAction.PICKUP_HALF && inv.getEditedSection().contains("sounds")) {
            inv.getEditedSection().set("sounds", null);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Custom Sounds successfully removed.");
        }
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        String soundsPath = (String)info[0];
        String[] split = message.split(" ");
        Validate.isTrue((split.length == 3 ? 1 : 0) != 0, (String)(message + " is not a valid [SOUND NAME] [VOLUME] [PITCH]."));
        String soundName = split[0].replace("-", "_");
        double volume = MMOUtils.parseDouble(split[1]);
        double pitch = MMOUtils.parseDouble(split[2]);
        inv.getEditedSection().set("sounds." + soundsPath + ".sound", (Object)soundName);
        inv.getEditedSection().set("sounds." + soundsPath + ".volume", (Object)volume);
        inv.getEditedSection().set("sounds." + soundsPath + ".pitch", (Object)pitch);
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + ChatColor.RED + UtilityMethods.caseOnWords((String)soundsPath.replace(".", " ")) + ChatColor.GRAY + " successfully changed to '" + soundName + "'.");
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<SoundListData> statData) {
        if (statData.isPresent()) {
            lore.add(ChatColor.GRAY + "Current Value:");
            SoundListData data = statData.get();
            data.mapData().forEach((sound, soundData) -> lore.add(ChatColor.GRAY + "* " + ChatColor.GREEN + UtilityMethods.caseOnWords((String)sound.getName().toLowerCase().replace("-", " ").replace("_", " ")) + ChatColor.GRAY + ": " + ChatColor.RED + soundData.getVolume() + " " + soundData.getPitch()));
        } else {
            lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.RED + "None");
        }
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Click to access the sounds edition menu.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove all custom sounds.");
    }

    @Override
    @NotNull
    public SoundListData getClearStatData() {
        return new SoundListData();
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull SoundListData data) {
        item.addItemTag(this.getAppliedNBT(data));
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull SoundListData data) {
        ArrayList<ItemTag> ret = new ArrayList<ItemTag>();
        SoundListData sounds = data;
        sounds.getCustomSounds().forEach(sound -> {
            SoundData value = sounds.get((CustomSound)((Object)sound));
            ret.add(new ItemTag("MMOITEMS_SOUND_" + sound.name(), (Object)value.getSound()));
            ret.add(new ItemTag("MMOITEMS_SOUND_" + sound.name() + "_VOL", (Object)value.getVolume()));
            ret.add(new ItemTag("MMOITEMS_SOUND_" + sound.name() + "_PIT", (Object)value.getPitch()));
        });
        return ret;
    }

    @Override
    @Nullable
    public SoundListData getLoadedNBT(@NotNull ArrayList<ItemTag> data) {
        SoundListData sounds = new SoundListData();
        for (CustomSound sound : CustomSound.values()) {
            ItemTag soundTag = ItemTag.getTagAtPath((String)("MMOITEMS_SOUND_" + sound.name()), data);
            ItemTag volumeTag = ItemTag.getTagAtPath((String)("MMOITEMS_SOUND_" + sound.name() + "_VOL"), data);
            ItemTag pitchTag = ItemTag.getTagAtPath((String)("MMOITEMS_SOUND_" + sound.name() + "_PIT"), data);
            if (soundTag == null || volumeTag == null || pitchTag == null) continue;
            String soundName = (String)soundTag.getValue();
            Double volume = (Double)volumeTag.getValue();
            Double pitch = (Double)pitchTag.getValue();
            if (soundName.isEmpty()) continue;
            sounds.set(sound, new SoundData(soundName, volume, pitch));
        }
        if (sounds.getCustomSounds().size() > 0) {
            return sounds;
        }
        return null;
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        ArrayList<ItemTag> relevantTags = new ArrayList<ItemTag>();
        for (CustomSound sound : CustomSound.values()) {
            ItemTag soundTag = null;
            ItemTag volumeTag = null;
            ItemTag pitchTag = null;
            if (mmoitem.getNBT().hasTag("MMOITEMS_SOUND_" + sound.name())) {
                soundTag = ItemTag.getTagAtPath((String)("MMOITEMS_SOUND_" + sound.name()), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING);
            }
            if (mmoitem.getNBT().hasTag("MMOITEMS_SOUND_" + sound.name() + "_VOL")) {
                volumeTag = ItemTag.getTagAtPath((String)("MMOITEMS_SOUND_" + sound.name() + "_VOL"), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.DOUBLE);
            }
            if (mmoitem.getNBT().hasTag("MMOITEMS_SOUND_" + sound.name() + "_PIT")) {
                pitchTag = ItemTag.getTagAtPath((String)("MMOITEMS_SOUND_" + sound.name() + "_PIT"), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.DOUBLE);
            }
            if (soundTag == null || volumeTag == null || pitchTag == null) continue;
            relevantTags.add(soundTag);
            relevantTags.add(volumeTag);
            relevantTags.add(pitchTag);
        }
        StatData sounds = this.getLoadedNBT((ArrayList)relevantTags);
        if (sounds != null) {
            mmoitem.setData(ItemStats.CUSTOM_SOUNDS, sounds);
        }
    }

    @Override
    public void onConsume(@NotNull VolatileMMOItem mmo, @NotNull Player player, boolean vanillaEating) {
        if (!mmo.hasData(ItemStats.CUSTOM_SOUNDS)) {
            this.playDefaultSound(player);
            return;
        }
        SoundListData slData = (SoundListData)mmo.getData(ItemStats.CUSTOM_SOUNDS);
        SoundData cs = slData.get(CustomSound.ON_CONSUME);
        if (cs == null) {
            this.playDefaultSound(player);
        } else {
            String fixedSoundName = cs.getSound().toLowerCase().replace("_", ".");
            player.getWorld().playSound(player.getLocation(), fixedSoundName, (float)cs.getVolume(), (float)cs.getPitch());
        }
    }

    void playDefaultSound(@NotNull Player player) {
        player.getWorld().playSound(player.getLocation(), Sounds.ENTITY_GENERIC_EAT, 1.0f, 1.0f);
    }
}

