/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.crafting.uimanager.ProvidedUIFilter;
import io.lumine.mythic.lib.api.crafting.uimanager.UIFilterManager;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.QuickNumberRange;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.gui.edition.recipe.RecipeTypeListGUI;
import net.Indyuce.mmoitems.gui.edition.recipe.button.RecipeButtonAction;
import net.Indyuce.mmoitems.gui.edition.recipe.gui.RecipeEditorGUI;
import net.Indyuce.mmoitems.gui.edition.recipe.interpreter.RMG_RecipeInterpreter;
import net.Indyuce.mmoitems.stat.data.StringData;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Crafting
extends ItemStat<RandomStatData<StatData>, StatData> {
    public Crafting() {
        super("CRAFTING", Material.CRAFTING_TABLE, "Crafting", new String[]{"The crafting recipes of your item.", "Changing a recipe requires &o/mi reload recipes&7."}, new String[0], new Material[0]);
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            new RecipeTypeListGUI(inv.getPlayer(), inv.getEdited()).open(inv);
        } else if (event.getAction() == InventoryAction.PICKUP_HALF && inv.getEditedSection().contains("crafting")) {
            inv.getEditedSection().set("crafting", null);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Crafting recipes successfully removed. Make sure you reload active recipes using " + ChatColor.RED + "/mi reload recipes" + ChatColor.GRAY + ".");
        }
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<RandomStatData<StatData>> statData) {
        lore.add(ChatColor.YELLOW + "\u25ba" + " Click to access the crafting edition menu.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove all crafting recipes.");
    }

    @Override
    @NotNull
    public StatData getClearStatData() {
        return new StringData(null);
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        int type = (Integer)info[0];
        switch (type) {
            case 0: 
            case 1: {
                int spc = message.indexOf(32);
                QuickNumberRange qnr = null;
                if (spc > 0) {
                    String qnrp = message.substring(spc + 1);
                    if (SilentNumbers.DoubleTryParse((String)qnrp)) {
                        qnrp = qnrp + "..";
                    }
                    qnr = QuickNumberRange.getFromString((String)qnrp);
                }
                if (spc <= 0 || qnr != null) {
                    if (qnr == null) {
                        qnr = new QuickNumberRange(Double.valueOf(1.0), null);
                    } else {
                        message = message.substring(0, spc);
                    }
                    if (message.contains(".")) {
                        String[] midSplit = message.split("\\.");
                        message = "m " + midSplit[0] + " " + midSplit[1] + " " + qnr;
                    } else {
                        message = "v " + message + " - " + qnr;
                    }
                }
                RMG_RecipeInterpreter interpreter = (RMG_RecipeInterpreter)info[1];
                int slot = (Integer)info[2];
                ProvidedUIFilter read = UIFilterManager.getUIFilter((String)message, (FriendlyFeedbackProvider)inv.getFFP());
                if (read == null) {
                    throw new IllegalArgumentException("");
                }
                if (!read.isValid(inv.getFFP())) {
                    throw new IllegalArgumentException("");
                }
                ConfigurationSection section = RecipeEditorGUI.getSection(inv.getEditedSection(), "crafting");
                section = RecipeEditorGUI.getSection(section, ((RecipeEditorGUI)inv).getRecipeRegistry().getRecipeConfigPath());
                section = RecipeEditorGUI.getSection(section, ((RecipeEditorGUI)inv).getRecipeName());
                if (type == 0) {
                    interpreter.editInput(read, slot);
                } else {
                    interpreter.editOutput(read, slot);
                }
                inv.registerTemplateEdition();
                break;
            }
            case 2: 
            case 3: {
                if (info.length < 2) {
                    return;
                }
                if (!(info[1] instanceof RecipeButtonAction)) {
                    return;
                }
                if (type == 2) {
                    ((RecipeButtonAction)info[1]).primaryProcessInput(message, info);
                } else {
                    ((RecipeButtonAction)info[1]).secondaryProcessInput(message, info);
                }
                inv.registerTemplateEdition();
                break;
            }
            default: {
                inv.registerTemplateEdition();
            }
        }
    }

    @Override
    @Nullable
    public RandomStatData whenInitialized(Object object) {
        return null;
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull StatData data) {
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull StatData data) {
        return new ArrayList<ItemTag>();
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
    }

    @Override
    @Nullable
    public StatData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        return null;
    }
}

