/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.gson.JsonArray;
import io.lumine.mythic.lib.gson.JsonParser;
import io.lumine.mythic.lib.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.StringListData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompatibleIds
extends ItemStat<StringListData, StringListData> {
    public CompatibleIds() {
        super("COMPATIBLE_IDS", Material.COMMAND_BLOCK, "Compatible IDs", new String[]{"The item ids this skin is", "compatible with."}, new String[]{"skin"}, new Material[0]);
    }

    @Override
    public StringListData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof List), (String)"Must specify a string list");
        return new StringListData((List)object);
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            new StatEdition(inv, this, new Object[0]).enable("Write in the chat the item id you want to add.");
        }
        if (event.getAction() != InventoryAction.PICKUP_HALF || !inv.getEditedSection().contains(this.getPath())) {
            return;
        }
        List lore = inv.getEditedSection().getStringList(this.getPath());
        if (lore.isEmpty()) {
            return;
        }
        String last = (String)lore.removeLast();
        inv.getEditedSection().set(this.getPath(), (Object)lore);
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully removed '" + last + "'.");
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        ArrayList<String> lore = inv.getEditedSection().contains(this.getPath()) ? inv.getEditedSection().getStringList(this.getPath()) : new ArrayList<String>();
        lore.add(message.toUpperCase());
        inv.getEditedSection().set(this.getPath(), lore);
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "ID '" + message.toUpperCase() + "' successfully added.");
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<StringListData> statData) {
        if (statData.isPresent()) {
            lore.add(ChatColor.GRAY + "Current Value:");
            statData.get().getList().forEach(str -> lore.add(ChatColor.GRAY + "* " + str));
        } else {
            lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.RED + "Compatible with any item.");
        }
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Click to add a new id.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove the last id.");
    }

    @Override
    @NotNull
    public StringListData getClearStatData() {
        return new StringListData();
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull StringListData data) {
        ArrayList<String> compatibleIds = new ArrayList<String>(data.getList());
        item.getLore().insert(this.getPath(), compatibleIds);
        item.addItemTag(this.getAppliedNBT(data));
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull StringListData data) {
        JsonArray array = new JsonArray();
        for (String sts : data.getList()) {
            array.add(sts);
        }
        ArrayList<ItemTag> tags = new ArrayList<ItemTag>();
        tags.add(new ItemTag(this.getNBTPath(), (Object)array.toString()));
        return tags;
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        StatData data;
        ArrayList<ItemTag> relevantTags = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            relevantTags.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING));
        }
        if ((data = this.getLoadedNBT((ArrayList)relevantTags)) != null) {
            mmoitem.setData(this, data);
        }
    }

    @Override
    @Nullable
    public StringListData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag rTag = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (rTag == null) {
            return null;
        }
        try {
            JsonArray array = new JsonParser().parse((String)rTag.getValue()).getAsJsonArray();
            return new StringListData(array);
        }
        catch (JsonSyntaxException | IllegalStateException throwable) {
            return null;
        }
    }
}

