/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.gson.JsonArray;
import io.lumine.mythic.lib.gson.JsonElement;
import io.lumine.mythic.lib.gson.JsonObject;
import io.lumine.mythic.lib.gson.JsonParser;
import io.lumine.mythic.lib.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.gui.edition.CommandListEdition;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.CommandData;
import net.Indyuce.mmoitems.stat.data.CommandListData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Commands
extends ItemStat<CommandListData, CommandListData> {
    private static final int MAXIMUM_COMMANDS = 15;

    public Commands() {
        super("COMMANDS", Material.COMMAND_BLOCK_MINECART, "Commands", new String[]{"The commands your item", "performs when right clicked."}, new String[]{"!armor", "!block", "!gem_stone", "all"}, new Material[0]);
    }

    @Override
    public CommandListData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof ConfigurationSection), (String)"Must specify a config section");
        ConfigurationSection config = (ConfigurationSection)object;
        CommandListData list = new CommandListData(new CommandData[0]);
        for (String key : config.getKeys(false)) {
            ConfigurationSection section = config.getConfigurationSection(key);
            list.add(new CommandData(section.getString("format"), section.getDouble("delay"), section.getBoolean("console"), section.getBoolean("op")));
        }
        return list;
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        new CommandListEdition(inv.getPlayer(), inv.getEdited()).open(inv);
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        if (inv.getEditedSection().contains("commands") && inv.getEditedSection().getConfigurationSection("commands").getKeys(false).size() >= 15) {
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Your item has reached the " + 15 + " commands limit.");
            return;
        }
        double delay = 0.0;
        boolean console = false;
        boolean op = false;
        String[] split = message.split(" ");
        for (int j = 0; j < split.length && split[j].startsWith("-"); ++j) {
            String arg = split[j];
            if (arg.startsWith("-d:")) {
                delay = MMOUtils.parseDouble(arg.substring(3));
                message = message.replaceFirst(arg + " ", "");
                continue;
            }
            if (arg.equalsIgnoreCase("-c")) {
                console = true;
                message = message.replaceFirst(arg + " ", "");
                continue;
            }
            if (!arg.equalsIgnoreCase("-op")) continue;
            op = true;
            message = message.replaceFirst(arg + " ", "");
        }
        ConfigurationSection commands = inv.getEditedSection().getConfigurationSection("commands");
        String path = "cmd16";
        if (commands == null) {
            path = "cmd0";
        } else {
            for (int j = 0; j < 15; ++j) {
                if (commands.contains("cmd" + j)) continue;
                path = "cmd" + j;
                break;
            }
        }
        inv.getEditedSection().set("commands." + path + ".format", (Object)message);
        inv.getEditedSection().set("commands." + path + ".delay", (Object)delay);
        inv.getEditedSection().set("commands." + path + ".console", (Object)(console ? Boolean.valueOf(console) : null));
        inv.getEditedSection().set("commands." + path + ".op", (Object)(op ? Boolean.valueOf(op) : null));
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Command successfully registered.");
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<CommandListData> statData) {
        lore.add(ChatColor.GRAY + "Current Commands: " + ChatColor.RED + (statData.isPresent() ? Integer.valueOf(statData.get().getCommands().size()) : "0"));
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Click to edit item commands.");
    }

    @Override
    @NotNull
    public CommandListData getClearStatData() {
        return new CommandListData(new CommandData[0]);
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull CommandListData data) {
        item.addItemTag(this.getAppliedNBT(data));
        ArrayList<String> lore = new ArrayList<String>();
        String commandFormat = this.getGeneralStatFormat();
        data.getCommands().forEach(command -> lore.add(commandFormat.replace("{format}", "/" + command.getCommand()).replace("{cooldown}", String.valueOf(command.getDelay()))));
        item.getLore().insert("commands", lore);
    }

    @Override
    public String getLegacyTranslationPath() {
        return "command";
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull CommandListData data) {
        ArrayList<ItemTag> ret = new ArrayList<ItemTag>();
        JsonArray array = new JsonArray();
        for (CommandData cd : data.getCommands()) {
            JsonObject object = new JsonObject();
            object.addProperty("Command", cd.getCommand());
            object.addProperty("Delay", (Number)cd.getDelay());
            object.addProperty("Console", Boolean.valueOf(cd.isConsoleCommand()));
            object.addProperty("Op", Boolean.valueOf(cd.hasOpPerms()));
            array.add((JsonElement)object);
        }
        ret.add(new ItemTag(this.getNBTPath(), (Object)array.toString()));
        return ret;
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        StatData data;
        ArrayList<ItemTag> relevantTag = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            relevantTag.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING));
        }
        if ((data = this.getLoadedNBT((ArrayList)relevantTag)) != null) {
            mmoitem.setData(this, data);
        }
    }

    @Override
    @Nullable
    public CommandListData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag relevant = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (relevant != null) {
            try {
                CommandListData commands = new CommandListData(new CommandData[0]);
                JsonArray ar = new JsonParser().parse((String)relevant.getValue()).getAsJsonArray();
                for (JsonElement e : ar) {
                    if (!e.isJsonObject()) continue;
                    JsonObject key = e.getAsJsonObject();
                    CommandData cd = new CommandData(key.get("Command").getAsString(), key.get("Delay").getAsDouble(), key.get("Console").getAsBoolean(), key.get("Op").getAsBoolean());
                    commands.add(cd);
                }
                return commands;
            }
            catch (JsonSyntaxException | IllegalStateException throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

