/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.version.Sounds;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.event.item.IdentifyItemEvent;
import net.Indyuce.mmoitems.api.interaction.Consumable;
import net.Indyuce.mmoitems.api.item.util.identify.IdentifiedItem;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.stat.type.BooleanStat;
import net.Indyuce.mmoitems.stat.type.ConsumableItemInteraction;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;

public class CanIdentify
extends BooleanStat
implements ConsumableItemInteraction {
    public CanIdentify() {
        super("CAN_IDENTIFY", Material.PAPER, "Can Identify?", new String[]{"Players can identify & make their", "item usable using this consumable."}, new String[]{"consumable"}, new Material[0]);
    }

    @Override
    public boolean handleConsumableEffect(@NotNull InventoryClickEvent event, @NotNull PlayerData playerData, @NotNull Consumable consumable, @NotNull NBTItem target, Type targetType) {
        if (targetType != null) {
            return false;
        }
        if (!consumable.getNBTItem().getBoolean("MMOITEMS_CAN_IDENTIFY") || !target.hasTag("MMOITEMS_UNIDENTIFIED_ITEM")) {
            return false;
        }
        Player player = playerData.getPlayer();
        if (target.getItem().getAmount() > 1) {
            Message.CANNOT_IDENTIFY_STACKED_ITEMS.format(ChatColor.RED, new String[0]).send(player);
            return false;
        }
        IdentifyItemEvent called = new IdentifyItemEvent(playerData, consumable.getMMOItem(), target);
        Bukkit.getPluginManager().callEvent((Event)called);
        if (called.isCancelled()) {
            return false;
        }
        event.setCurrentItem(new IdentifiedItem(target).identify());
        Message.SUCCESSFULLY_IDENTIFIED.format(ChatColor.YELLOW, "#item#", MMOUtils.getDisplayName(target.getItem())).send(player);
        player.playSound(player.getLocation(), Sounds.ENTITY_PLAYER_LEVELUP, 1.0f, 2.0f);
        return true;
    }
}

