/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.util.SmartGive;
import io.lumine.mythic.lib.gson.JsonObject;
import java.util.Objects;
import java.util.logging.Level;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.interaction.Consumable;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.stat.data.ParticleData;
import net.Indyuce.mmoitems.stat.data.SkullTextureData;
import net.Indyuce.mmoitems.stat.type.BooleanStat;
import net.Indyuce.mmoitems.stat.type.ConsumableItemInteraction;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

public class CanDeskin
extends BooleanStat
implements ConsumableItemInteraction {
    public CanDeskin() {
        super("CAN_DESKIN", Material.LEATHER, "Can Deskin?", new String[]{"Players can deskin their item", "and get their skin back", "from the item."}, new String[]{"consumable"}, new Material[0]);
    }

    @Override
    public boolean handleConsumableEffect(@NotNull InventoryClickEvent event, @NotNull PlayerData playerData, @NotNull Consumable consumable, @NotNull NBTItem target, Type targetType) {
        String skinId = target.getString("MMOITEMS_SKIN_ID");
        Player player = playerData.getPlayer();
        if (consumable.getNBTItem().getBoolean("MMOITEMS_CAN_DESKIN") && !skinId.isEmpty()) {
            String targetItemId = target.getString("MMOITEMS_ITEM_ID");
            target.removeTag(new String[]{"MMOITEMS_SKIN_ID"});
            MMOItemTemplate targetTemplate = MMOItems.plugin.getTemplates().getTemplateOrThrow(targetType, targetItemId);
            MMOItem originalMmoitem = targetTemplate.newBuilder(playerData.getRPG()).build();
            ItemStack originalItem = targetTemplate.newBuilder(playerData.getRPG()).build().newBuilder().build();
            if (originalMmoitem.hasData(ItemStats.ITEM_PARTICLES)) {
                JsonObject itemParticles = ((ParticleData)originalMmoitem.getData(ItemStats.ITEM_PARTICLES)).toJson();
                target.addTag(new ItemTag[]{new ItemTag("MMOITEMS_ITEM_PARTICLES", (Object)itemParticles.toString())});
            } else {
                target.removeTag(new String[]{"MMOITEMS_ITEM_PARTICLES"});
            }
            ItemStack targetItem = target.toItem();
            ItemMeta targetItemMeta = targetItem.getItemMeta();
            ItemMeta originalItemMeta = originalItem.getItemMeta();
            Integer originalCustomModelData = originalItemMeta.hasCustomModelData() ? Integer.valueOf(originalItemMeta.getCustomModelData()) : null;
            targetItemMeta.setCustomModelData(originalCustomModelData);
            if (targetItemMeta.isUnbreakable()) {
                targetItemMeta.setUnbreakable(originalItemMeta.isUnbreakable());
                if (targetItemMeta instanceof Damageable && originalItemMeta instanceof Damageable) {
                    ((Damageable)targetItemMeta).setDamage(((Damageable)originalItemMeta).getDamage());
                }
            }
            if (targetItemMeta instanceof LeatherArmorMeta && originalItemMeta instanceof LeatherArmorMeta) {
                ((LeatherArmorMeta)targetItemMeta).setColor(((LeatherArmorMeta)originalItemMeta).getColor());
            }
            if (targetItemMeta instanceof ArmorMeta && originalItemMeta instanceof ArmorMeta) {
                ((ArmorMeta)targetItemMeta).setTrim(((ArmorMeta)originalItemMeta).getTrim());
                if (originalItemMeta.hasItemFlag(ItemFlag.HIDE_ARMOR_TRIM)) {
                    targetItemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ARMOR_TRIM});
                } else {
                    targetItemMeta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ARMOR_TRIM});
                }
            }
            if (target.hasTag("SkullOwner") && targetItem.getType() == Material.PLAYER_HEAD && originalItem.getType() == Material.PLAYER_HEAD) {
                MythicLib.plugin.getVersion().getWrapper().setProfile((SkullMeta)targetItemMeta, ((SkullTextureData)originalMmoitem.getData(ItemStats.SKULL_TEXTURE)).getGameProfile());
            }
            ItemStack updated = target.getItem();
            updated.setItemMeta(targetItemMeta);
            updated.setType(originalItem.getType());
            try {
                String skinTypeId = target.getString("MMOITEMS_SKIN_TYPE");
                Type type = Objects.requireNonNullElse(Type.get(skinTypeId), Type.SKIN);
                MMOItemTemplate template = MMOItems.plugin.getTemplates().getTemplateOrThrow(type, skinId);
                Validate.notNull((Object)template, (String)("Could not find item template of applied skin, type used " + type.getName()));
                MMOItem mmoitem = template.newBuilder(playerData.getRPG()).build();
                new SmartGive(player).give(new ItemStack[]{mmoitem.newBuilder().build()});
            }
            catch (Exception exception) {
                MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not retrieve item skin with ID '" + skinId + "' for player " + playerData.getUniqueId());
            }
            Message.SKIN_REMOVED.format(ChatColor.YELLOW, "#item#", MMOUtils.getDisplayName(targetItem)).send(player);
            return true;
        }
        return false;
    }
}

