/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.stat.annotation.HasCategory;
import net.Indyuce.mmoitems.stat.data.DoubleData;
import net.Indyuce.mmoitems.stat.type.DoubleStat;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@HasCategory(cat="template_option")
public class BrowserDisplayIDX
extends DoubleStat {
    public BrowserDisplayIDX() {
        super("BROWSER_IDX", Material.GHAST_TEAR, "Browser Index", new String[]{"Used to display similar items together,", "neatly in the GUI \u00a7a/mmoitems browse", "", "Items with the same index are grouped."}, new String[0], new Material[0]);
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull DoubleData data) {
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
    }

    @NotNull
    public static HashMap<Double, ArrayList<MMOItemTemplate>> select(@NotNull Collection<MMOItemTemplate> templates) {
        HashMap<Double, ArrayList<MMOItemTemplate>> ret = new HashMap<Double, ArrayList<MMOItemTemplate>>();
        for (MMOItemTemplate template : templates) {
            ArrayList<MMOItemTemplate> perIndexTemplates;
            NumericStatFormula indexData;
            if (template == null) continue;
            Double armorIDX = null;
            if (template.getType().getAvailableStats().contains(ItemStats.BROWSER_DISPLAY_IDX) && (indexData = (NumericStatFormula)template.getBaseItemData().get(ItemStats.BROWSER_DISPLAY_IDX)) != null && indexData.getBase() != 0.0) {
                armorIDX = indexData.getBase();
            }
            if ((perIndexTemplates = ret.get(armorIDX)) == null) {
                perIndexTemplates = new ArrayList();
            }
            perIndexTemplates.add(template);
            ret.put(armorIDX, perIndexTemplates);
        }
        return ret;
    }

    @Nullable
    public static MMOItemTemplate getAt(int i, @NotNull HashMap<Double, ArrayList<MMOItemTemplate>> templates) {
        Map.Entry<Double, ArrayList<MMOItemTemplate>> nullEntry = null;
        for (Map.Entry<Double, ArrayList<MMOItemTemplate>> entry : templates.entrySet()) {
            if (entry.getKey() == null) {
                nullEntry = entry;
                continue;
            }
            ArrayList<MMOItemTemplate> list = entry.getValue();
            while (list.size() % 4 != 0) {
                list.add(null);
            }
            for (MMOItemTemplate observed : list) {
                if (i == 0) {
                    return observed;
                }
                --i;
            }
        }
        if (nullEntry == null) {
            return null;
        }
        ArrayList list = (ArrayList)nullEntry.getValue();
        for (MMOItemTemplate observed : list) {
            if (i == 0) {
                return observed;
            }
            --i;
        }
        return null;
    }
}

