/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.gson.JsonObject;
import io.lumine.mythic.lib.gson.JsonParser;
import io.lumine.mythic.lib.gson.JsonSyntaxException;
import io.lumine.mythic.lib.version.VParticle;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.gui.edition.ArrowParticlesEdition;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.ArrowParticlesData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrowParticles
extends ItemStat<ArrowParticlesData, ArrowParticlesData> {
    public ArrowParticles() {
        super("ARROW_PARTICLES", Material.SPECTRAL_ARROW, "Arrow Particles", new String[]{"Particles that display around", "the arrows your bow fires."}, new String[]{"bow", "crossbow"}, new Material[0]);
    }

    @Override
    public ArrowParticlesData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof ConfigurationSection), (String)"Must specify a valid config section");
        ConfigurationSection config = (ConfigurationSection)object;
        Validate.isTrue((boolean)config.contains("particle"), (String)"Could not find arrow particle");
        Particle particle = Particle.valueOf((String)config.getString("particle").toUpperCase().replace("-", "_").replace(" ", "_"));
        int amount = config.getInt("amount");
        double offset = config.getDouble("offset");
        return MMOUtils.isColorable(particle) ? new ArrowParticlesData(particle, amount, offset, config.getInt("color.red"), config.getInt("color.green"), config.getInt("color.blue")) : new ArrowParticlesData(particle, amount, offset, config.getDouble("speed"));
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull ArrowParticlesData data) {
        item.addItemTag(this.getAppliedNBT(data));
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull ArrowParticlesData data) {
        ArrayList<ItemTag> tags = new ArrayList<ItemTag>();
        tags.add(new ItemTag(this.getNBTPath(), (Object)data.toString()));
        return tags;
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        StatData data;
        ArrayList<ItemTag> relevantTags = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            relevantTags.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING));
        }
        if ((data = this.getLoadedNBT((ArrayList)relevantTags)) != null) {
            mmoitem.setData(this, data);
        }
    }

    @Override
    @Nullable
    public ArrowParticlesData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag tagS = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (tagS != null) {
            try {
                JsonObject json = new JsonParser().parse((String)tagS.getValue()).getAsJsonObject();
                Particle particle = Particle.valueOf((String)json.get("Particle").getAsString());
                int amount = json.get("Amount").getAsInt();
                double offset = json.get("Offset").getAsDouble();
                if (MMOUtils.isColorable(particle)) {
                    return new ArrowParticlesData(particle, amount, offset, json.get("Red").getAsInt(), json.get("Green").getAsInt(), json.get("Blue").getAsInt());
                }
                return new ArrowParticlesData(particle, amount, offset, json.get("Speed").getAsDouble());
            }
            catch (JsonSyntaxException | IllegalStateException throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        new ArrowParticlesEdition(inv.getPlayer(), inv.getEdited()).open(inv);
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        String edited = (String)info[0];
        if (edited.equals("color")) {
            String[] split = message.split(" ");
            int red = Integer.parseInt(split[0]);
            int green = Integer.parseInt(split[1]);
            int blue = Integer.parseInt(split[2]);
            inv.getEditedSection().set("arrow-particles.color.red", (Object)red);
            inv.getEditedSection().set("arrow-particles.color.green", (Object)green);
            inv.getEditedSection().set("arrow-particles.color.blue", (Object)blue);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Particle color successfully set to " + ChatColor.translateAlternateColorCodes((char)'&', (String)("&c&l" + red + "&7 - &a&l" + green + "&7 - &9&l" + blue)));
            return;
        }
        if (edited.equals("particle")) {
            Particle particle = Particle.valueOf((String)message.toUpperCase().replace("-", "_").replace(" ", "_"));
            inv.getEditedSection().set("arrow-particles.particle", (Object)particle.name());
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Particle successfully set to " + ChatColor.GOLD + UtilityMethods.caseOnWords((String)particle.name().toLowerCase().replace("_", " ")) + ChatColor.GRAY + ".");
            return;
        }
        if (edited.equals("amount")) {
            int value = Integer.parseInt(message);
            inv.getEditedSection().set("arrow-particles.amount", (Object)value);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + ChatColor.GOLD + "Amount" + ChatColor.GRAY + " set to " + ChatColor.GOLD + value + ChatColor.GRAY + ".");
            return;
        }
        double value = MMOUtils.parseDouble(message);
        inv.getEditedSection().set("arrow-particles." + edited, (Object)value);
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + ChatColor.GOLD + UtilityMethods.caseOnWords((String)edited.replace("-", " ")) + ChatColor.GRAY + " set to " + ChatColor.GOLD + value + ChatColor.GRAY + ".");
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<ArrowParticlesData> statData) {
        if (statData.isPresent()) {
            ArrowParticlesData cast = statData.get();
            lore.add(ChatColor.GRAY + "Current Value:");
            lore.add(ChatColor.GRAY + "* Particle: " + ChatColor.GOLD + UtilityMethods.caseOnWords((String)cast.getParticle().name().replace("_", " ").toLowerCase()));
            lore.add(ChatColor.GRAY + "* Amount: " + ChatColor.WHITE + cast.getAmount());
            lore.add(ChatColor.GRAY + "* Offset: " + ChatColor.WHITE + cast.getOffset());
            lore.add("");
            if (MMOUtils.isColorable(cast.getParticle())) {
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7* Color: &c&l" + cast.getRed() + "&7 - &a&l" + cast.getGreen() + "&7 - &9&l" + cast.getBlue())));
            } else {
                lore.add(ChatColor.GRAY + "* Speed: " + ChatColor.WHITE + cast.getSpeed());
            }
        } else {
            lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.RED + "None");
        }
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Click to edit.");
    }

    @Override
    @NotNull
    public ArrowParticlesData getClearStatData() {
        return new ArrowParticlesData(VParticle.LARGE_EXPLOSION.get(), 1, 0.0, 1.0);
    }
}

