/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import net.Indyuce.mmoitems.stat.data.StringData;
import net.Indyuce.mmoitems.stat.type.ChooseStat;
import net.Indyuce.mmoitems.stat.type.GemStoneStat;
import net.Indyuce.mmoitems.stat.type.ItemRestriction;
import net.Indyuce.mmoitems.util.StatChoice;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;

public class Amphibian
extends ChooseStat
implements ItemRestriction,
GemStoneStat {
    public static final StatChoice NORMAL = new StatChoice("NORMAL", "No liquids dependency");
    public static final StatChoice DRY = new StatChoice("DRY", "The item does not work if the player is touching a liquid block.");
    public static final StatChoice WET = new StatChoice("WET", "The only works if the player is touching water (rain does not count).");
    public static final StatChoice DAMP = new StatChoice("DAMP", "The only works if the player is completely submerged in water.");
    public static final StatChoice LAVA = new StatChoice("LAVA", "The only works if the player is touching lava.");
    public static final StatChoice MOLTEN = new StatChoice("MOLTEN", "The only works if the player is completely submerged in lava.");
    public static final StatChoice LIQUID = new StatChoice("LIQUID", "The only works if the player is touching any liquid.");
    public static final StatChoice SUBMERGED = new StatChoice("SUBMERGED", "The only works if the player is completely submerged in any liquid.");

    public Amphibian() {
        super("AMPHIBIAN", Material.WATER_BUCKET, "Amphibian", new String[]{"May this item only be used in specific", "environments regarding liquids?"}, new String[]{"!block", "all"}, new Material[0]);
        this.addChoices(NORMAL, DRY, WET, DAMP, LAVA, MOLTEN, LIQUID, SUBMERGED);
    }

    @Override
    @NotNull
    public StringData getClearStatData() {
        return new StringData(NORMAL.getId());
    }

    @Override
    public boolean canUse(RPGPlayer player, NBTItem item, boolean message) {
        String data;
        if (!item.hasTag(this.getNBTPath())) {
            return true;
        }
        ArrayList<ItemTag> relevantTags = new ArrayList<ItemTag>();
        if (item.hasTag(this.getNBTPath())) {
            relevantTags.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)item, (SupportedNBTTagValues)SupportedNBTTagValues.STRING));
        }
        if ((data = ((StringData)this.getLoadedNBT((ArrayList)relevantTags)).toString()) != null) {
            switch (data) {
                default: {
                    return true;
                }
                case "DRY": {
                    for (Block b : this.blocksTouchedByPlayer(player.getPlayer())) {
                        if (!b.isLiquid()) continue;
                        return false;
                    }
                    return true;
                }
                case "WET": {
                    for (Block b : this.blocksTouchedByPlayer(player.getPlayer())) {
                        if (!b.getType().equals((Object)Material.WATER)) continue;
                        return true;
                    }
                    return false;
                }
                case "DAMP": {
                    for (Block b : this.blocksTouchedByPlayer(player.getPlayer())) {
                        if (b.getType().equals((Object)Material.WATER)) continue;
                        return false;
                    }
                    return true;
                }
                case "LAVA": {
                    for (Block b : this.blocksTouchedByPlayer(player.getPlayer())) {
                        if (!b.getType().equals((Object)Material.LAVA)) continue;
                        return true;
                    }
                    return false;
                }
                case "MOLTEN": {
                    for (Block b : this.blocksTouchedByPlayer(player.getPlayer())) {
                        if (b.getType().equals((Object)Material.LAVA)) continue;
                        return false;
                    }
                    return true;
                }
                case "LIQUID": {
                    for (Block b : this.blocksTouchedByPlayer(player.getPlayer())) {
                        if (!b.isLiquid()) continue;
                        return true;
                    }
                    return false;
                }
                case "SUBMERGED": 
            }
            for (Block b : this.blocksTouchedByPlayer(player.getPlayer())) {
                if (b.isLiquid()) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    ArrayList<Block> blocksTouchedByPlayer(@NotNull Player p) {
        BoundingBox box = p.getBoundingBox();
        ArrayList<Block> ret = new ArrayList<Block>();
        for (double dx = box.getMinX(); dx <= box.getMaxX(); dx += Math.min(1.0, Math.max(box.getWidthX() - (dx - box.getMinX()), 0.001))) {
            for (double dy = box.getMinY(); dy <= box.getMaxY(); dy += Math.min(1.0, Math.max(box.getHeight() - (dy - box.getMinY()), 0.001))) {
                for (double dz = box.getMinZ(); dz <= box.getMaxZ(); dz += Math.min(1.0, Math.max(box.getWidthZ() - (dz - box.getMinZ()), 0.001))) {
                    int dxI = SilentNumbers.floor((double)dx);
                    int dyI = SilentNumbers.floor((double)dy);
                    int dzI = SilentNumbers.floor((double)dz);
                    Block bkk = p.getLocation().getWorld().getBlockAt(dxI, dyI, dzI);
                    if (ret.contains(bkk)) continue;
                    ret.add(bkk);
                }
            }
        }
        return ret;
    }
}

