/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.gson.JsonArray;
import io.lumine.mythic.lib.gson.JsonElement;
import io.lumine.mythic.lib.gson.JsonObject;
import io.lumine.mythic.lib.gson.JsonParser;
import io.lumine.mythic.lib.gson.JsonSyntaxException;
import io.lumine.mythic.lib.skill.trigger.TriggerType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.gui.edition.AbilityListEdition;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.skill.RegisteredSkill;
import net.Indyuce.mmoitems.stat.data.AbilityData;
import net.Indyuce.mmoitems.stat.data.AbilityListData;
import net.Indyuce.mmoitems.stat.data.random.RandomAbilityData;
import net.Indyuce.mmoitems.stat.data.random.RandomAbilityListData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Abilities
extends ItemStat<RandomAbilityListData, AbilityListData> {
    private String generalFormat;
    private String modifierIfAny;
    private String modifierForEach;
    private String modifierSplitter;
    private String abilitySplitter;
    private String modifierNewLine;
    private boolean useAbilitySplitter;
    private int modifiersPerLine;

    public Abilities() {
        super("ABILITY", Material.BLAZE_POWDER, "Item Abilities", new String[]{"Make your item cast amazing abilities", "to kill monsters or buff yourself."}, new String[]{"!block", "all"}, new Material[0]);
    }

    @Override
    public RandomAbilityListData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof ConfigurationSection), (String)"Must specify a valid config section");
        ConfigurationSection config = (ConfigurationSection)object;
        RandomAbilityListData list = new RandomAbilityListData(new RandomAbilityData[0]);
        for (String key : config.getKeys(false)) {
            list.add(new RandomAbilityData(config.getConfigurationSection(key)));
        }
        return list;
    }

    @Override
    public void loadConfiguration(@NotNull ConfigurationSection legacyLanguageFile, @NotNull Object configObject) {
        if (!(configObject instanceof ConfigurationSection)) {
            this.generalFormat = legacyLanguageFile.getString("ability-format");
            this.modifierIfAny = "\n";
            this.modifierNewLine = "\n";
            this.modifierForEach = legacyLanguageFile.getString("ability-modifier");
            this.modifierSplitter = "";
            this.abilitySplitter = legacyLanguageFile.getString("ability-splitter");
            this.useAbilitySplitter = this.abilitySplitter != null && !this.abilitySplitter.isEmpty();
            this.modifiersPerLine = 1;
            return;
        }
        ConfigurationSection config = (ConfigurationSection)configObject;
        this.generalFormat = config.getString("general-format");
        this.modifierIfAny = config.getString("modifier-if-any", "");
        this.modifierNewLine = "\n" + config.getString("modifier-new-line", "");
        this.modifierForEach = config.getString("modifier-foreach");
        this.modifierSplitter = config.getString("modifier-splitter");
        this.abilitySplitter = config.getString("ability-splitter.format");
        this.useAbilitySplitter = config.getBoolean("ability-splitter.enabled");
        this.modifiersPerLine = config.getInt("modifiers-per-line");
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull AbilityListData data) {
        ArrayList<String> abilityLore = new ArrayList<String>();
        data.getAbilities().forEach(ability -> {
            StringBuilder builder = new StringBuilder(this.generalFormat.replace("{trigger}", MMOItems.plugin.getLanguage().getTriggerTypeName(ability.getTrigger())).replace("{ability}", ability.getAbility().getName()));
            if (!ability.getModifiers().isEmpty()) {
                builder.append(this.modifierIfAny);
            }
            boolean newLine = false;
            int lineCounter = 0;
            for (String modifier : ability.getModifiers()) {
                String formattedValue = MythicLib.plugin.getMMOConfig().decimals.format(ability.getParameter(modifier));
                item.getLore().registerPlaceholder("ability_" + ability.getAbility().getHandler().getId().toLowerCase() + "_" + modifier, formattedValue);
                builder.append(newLine ? this.modifierNewLine : this.modifierSplitter);
                builder.append(this.modifierForEach.replace("{modifier}", ability.getAbility().getParameterName(modifier)).replace("{value}", formattedValue));
                newLine = false;
                if (this.modifiersPerLine <= 0 || ++lineCounter < this.modifiersPerLine) continue;
                lineCounter = 0;
                newLine = true;
            }
            abilityLore.add(builder.toString());
            if (this.useAbilitySplitter) {
                abilityLore.add(this.abilitySplitter);
            }
        });
        if (this.useAbilitySplitter && !abilityLore.isEmpty()) {
            abilityLore.remove(abilityLore.size() - 1);
        }
        item.getLore().insert("abilities", abilityLore);
        item.addItemTag(this.getAppliedNBT(data));
    }

    @Override
    public String getLegacyTranslationPath() {
        return "ability-format";
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull AbilityListData data) {
        ArrayList<ItemTag> ret = new ArrayList<ItemTag>();
        JsonArray jsonArray = new JsonArray();
        for (AbilityData ab : data.getAbilities()) {
            jsonArray.add((JsonElement)ab.toJson());
        }
        ret.add(new ItemTag(this.getNBTPath(), (Object)jsonArray.toString()));
        return ret;
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        new AbilityListEdition(inv.getPlayer(), inv.getEdited()).open(inv);
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        String configKey = (String)info[0];
        String edited = (String)info[1];
        String format = message.toUpperCase().replace("-", "_").replace(" ", "_").replaceAll("[^A-Z0-9_]", "");
        if (edited.equals("ability")) {
            Validate.isTrue((boolean)MMOItems.plugin.getSkills().hasSkill(format), (String)(format + " is not a valid ability! You may check the ability list using /mi list ability."));
            RegisteredSkill ability = MMOItems.plugin.getSkills().getSkill(format);
            inv.getEditedSection().set("ability." + configKey, null);
            inv.getEditedSection().set("ability." + configKey + ".type", (Object)format);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully set the ability to " + ChatColor.GOLD + ability.getName() + ChatColor.GRAY + ".");
            return;
        }
        if (edited.equals("mode")) {
            TriggerType castMode = TriggerType.valueOf((String)format);
            inv.getEditedSection().set("ability." + configKey + ".mode", (Object)castMode.name());
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully set the trigger to " + ChatColor.GOLD + castMode.getName() + ChatColor.GRAY + ".");
            return;
        }
        new NumericStatFormula(message).fillConfigurationSection(inv.getEditedSection(), "ability." + configKey + "." + edited, NumericStatFormula.FormulaSaveOption.NONE);
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + ChatColor.GOLD + UtilityMethods.caseOnWords((String)edited.replace("-", " ")) + ChatColor.GRAY + " successfully added.");
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<RandomAbilityListData> statData) {
        lore.add(ChatColor.GRAY + "Current Abilities: " + ChatColor.GOLD + (statData.isPresent() ? statData.get().getAbilities().size() : 0));
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Click to edit the item abilities.");
    }

    @Override
    @NotNull
    public AbilityListData getClearStatData() {
        return new AbilityListData(new AbilityData[0]);
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        StatData data;
        ArrayList<ItemTag> relevantTags = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            relevantTags.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING));
        }
        if ((data = this.getLoadedNBT((ArrayList)relevantTags)) != null) {
            mmoitem.setData(this, data);
        }
    }

    @Override
    @Nullable
    public AbilityListData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag jsonCompact = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (jsonCompact != null) {
            try {
                AbilityListData list = new AbilityListData(new AbilityData[0]);
                JsonArray ar = new JsonParser().parse((String)jsonCompact.getValue()).getAsJsonArray();
                for (JsonElement e : ar) {
                    if (!e.isJsonObject()) continue;
                    JsonObject obj = e.getAsJsonObject();
                    list.add(new AbilityData(obj));
                }
                return list;
            }
            catch (JsonSyntaxException | IllegalStateException throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

