/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.manager;

import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackCategory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ConfigFile;
import net.Indyuce.mmoitems.api.ItemTier;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.gui.edition.recipe.gui.RecipeEditorGUI;
import net.Indyuce.mmoitems.manager.Reloadable;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TierManager
implements Reloadable {
    private final Map<String, ItemTier> tiers = new HashMap<String, ItemTier>();

    public TierManager() {
        this.reload();
    }

    @Override
    public void reload() {
        this.tiers.clear();
        FriendlyFeedbackProvider ffp = new FriendlyFeedbackProvider((FriendlyFeedbackPalette)FFPMMOItems.get());
        ffp.activatePrefix(true, "Tiers");
        ConfigFile config = new ConfigFile("item-tiers");
        for (String tierName : config.getConfig().getKeys(false)) {
            ConfigurationSection tierSection = RecipeEditorGUI.getSection((ConfigurationSection)config.getConfig(), tierName);
            try {
                this.register(new ItemTier(tierSection));
            }
            catch (IllegalArgumentException exception) {
                ffp.log(FriendlyFeedbackCategory.ERROR, "Cannot register tier '$u{0}$b';$f {1}", new String[]{tierName, exception.getMessage()});
            }
        }
        ffp.sendTo(FriendlyFeedbackCategory.ERROR, MMOItems.getConsole());
        ffp.sendTo(FriendlyFeedbackCategory.FAILURE, MMOItems.getConsole());
    }

    public void register(@NotNull ItemTier tier) {
        this.tiers.put(tier.getId(), tier);
    }

    public boolean has(@Nullable String id) {
        if (id == null) {
            return false;
        }
        return this.tiers.containsKey(id);
    }

    @NotNull
    public ItemTier getOrThrow(@Nullable String id) throws IllegalArgumentException {
        Validate.isTrue((boolean)this.tiers.containsKey(id), (String)FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Could not find tier with ID '$r{0}$b'", (String[])new String[]{id}));
        return this.tiers.get(id);
    }

    @Nullable
    public ItemTier get(@Nullable String id) {
        if (id == null) {
            return null;
        }
        return this.tiers.get(id);
    }

    @NotNull
    public Collection<ItemTier> getAll() {
        return this.tiers.values();
    }

    @Deprecated
    @Nullable
    public ItemTier findTier(@NotNull MMOItem item) {
        return item.getTier();
    }
}

