/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.manager;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.element.Element;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ConfigFile;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.manager.ConfigManager;
import net.Indyuce.mmoitems.stat.annotation.DeprecatedStat;
import net.Indyuce.mmoitems.stat.annotation.HasCategory;
import net.Indyuce.mmoitems.stat.category.StatCategory;
import net.Indyuce.mmoitems.stat.type.BooleanStat;
import net.Indyuce.mmoitems.stat.type.ConsumableItemInteraction;
import net.Indyuce.mmoitems.stat.type.DoubleStat;
import net.Indyuce.mmoitems.stat.type.FakeElementalStat;
import net.Indyuce.mmoitems.stat.type.GemStoneStat;
import net.Indyuce.mmoitems.stat.type.ItemRestriction;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.stat.type.PlayerConsumable;
import net.Indyuce.mmoitems.stat.type.StringListStat;
import net.Indyuce.mmoitems.stat.type.StringStat;
import net.Indyuce.mmoitems.util.ElementStatType;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatManager {
    private final Map<String, ItemStat<?, ?>> stats = new LinkedHashMap();
    private final Map<String, StatCategory> categories = new HashMap<String, StatCategory>();
    private final Map<String, ItemStat<?, ?>> legacyAliases = new HashMap();
    private final List<DoubleStat> numericStats = new ArrayList<DoubleStat>();
    private final List<ItemRestriction> itemRestrictions = new ArrayList<ItemRestriction>();
    private final List<ConsumableItemInteraction> consumableActions = new ArrayList<ConsumableItemInteraction>();
    private final List<PlayerConsumable> playerConsumables = new ArrayList<PlayerConsumable>();

    public void loadBuiltins() {
        for (Field field : StatCategory.class.getFields()) {
            try {
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !(field.get(null) instanceof StatCategory)) continue;
                this.registerCategory((StatCategory)field.get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                MMOItems.plugin.getLogger().log(Level.SEVERE, String.format("Couldn't register category called '%s': %s", field.getName(), exception.getMessage()));
            }
        }
        for (Field field : ItemStats.class.getFields()) {
            try {
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !(field.get(null) instanceof ItemStat) || field.getAnnotation(DeprecatedStat.class) != null) continue;
                this.register((ItemStat)field.get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                MMOItems.plugin.getLogger().log(Level.SEVERE, String.format("Couldn't register stat called '%s': %s", field.getName(), exception.getMessage()));
            }
        }
        this.loadCustomStats();
    }

    public void reload(boolean cleanFirst) {
        if (cleanFirst) {
            this.numericStats.removeIf(stat -> stat instanceof FakeElementalStat);
        }
        this.loadElements();
        FileConfiguration statOptions = new ConfigFile("/language", "stats").getConfig();
        for (ItemStat<?, ?> stat2 : this.getAll()) {
            try {
                Object object = statOptions.get(stat2.getPath());
                if (object == null) {
                    object = statOptions.get(stat2.getLegacyTranslationPath());
                }
                stat2.loadConfiguration((ConfigurationSection)statOptions, object != null ? object : "<TranslationNotFound:" + stat2.getPath() + ">");
            }
            catch (RuntimeException exception) {
                MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not load translation info for stat '" + stat2.getId() + "': " + exception.getMessage());
            }
        }
    }

    private void loadCustomStats() {
        ConfigManager.DefaultFile.CUSTOM_STATS.checkFile();
        ConfigFile config = new ConfigFile("custom-stats");
        ConfigurationSection section = config.getConfig().getConfigurationSection("custom-stats");
        Validate.notNull((Object)section, (String)"Custom stats section is null");
        section.getKeys(true).stream().filter(arg_0 -> ((ConfigurationSection)section).isConfigurationSection(arg_0)).map(arg_0 -> ((ConfigurationSection)section).getConfigurationSection(arg_0)).filter(Objects::nonNull).forEach(this::registerCustomStat);
    }

    public void loadElements() {
        for (ElementStatType type : ElementStatType.values()) {
            for (Element element : MythicLib.plugin.getElements().getAll()) {
                this.numericStats.add(new FakeElementalStat(element, type));
            }
        }
    }

    public void registerCategory(@NotNull StatCategory category) {
        this.categories.put(category.getId(), category);
    }

    @NotNull
    public StatCategory getCategory(@NotNull String id) {
        return Objects.requireNonNull(this.categories.get(id), "No stat category found with ID '" + id + "'");
    }

    @NotNull
    public Collection<ItemStat<?, ?>> getAll() {
        return this.stats.values();
    }

    @NotNull
    public List<DoubleStat> getNumericStats() {
        return this.numericStats;
    }

    @NotNull
    public List<ItemRestriction> getItemRestrictionStats() {
        return this.itemRestrictions;
    }

    @NotNull
    public List<ConsumableItemInteraction> getConsumableActions() {
        return this.consumableActions;
    }

    @NotNull
    public List<PlayerConsumable> getPlayerConsumables() {
        return this.playerConsumables;
    }

    public boolean has(String id) {
        return this.stats.containsKey(id);
    }

    @Nullable
    public ItemStat<?, ?> get(String id) {
        ItemStat<?, ?> stat = this.stats.get(id);
        if (stat != null) {
            return stat;
        }
        stat = this.numericStats.stream().filter(doubleStat -> doubleStat.getId().equals(id)).findFirst().orElse(null);
        if (stat != null) {
            return stat;
        }
        stat = this.legacyAliases.get(id);
        if (stat != null) {
            return stat;
        }
        return null;
    }

    public void register(@NotNull ItemStat<?, ?> stat) {
        HasCategory statCatAnnot;
        if (!stat.isEnabled()) {
            return;
        }
        this.stats.compute(stat.getId(), (id, current) -> {
            Validate.isTrue((current == null ? 1 : 0) != 0, (String)("A stat with ID '" + id + "' already exists"));
            return stat;
        });
        for (String alias : stat.getAliases()) {
            this.legacyAliases.put(alias, stat);
        }
        if (stat instanceof DoubleStat && !(stat instanceof GemStoneStat) && stat.isCompatible(Type.GEM_STONE)) {
            this.numericStats.add((DoubleStat)stat);
        }
        if (stat instanceof ItemRestriction) {
            this.itemRestrictions.add((ItemRestriction)((Object)stat));
        }
        if (stat instanceof ConsumableItemInteraction) {
            this.consumableActions.add((ConsumableItemInteraction)((Object)stat));
        }
        if (stat instanceof PlayerConsumable) {
            this.playerConsumables.add((PlayerConsumable)((Object)stat));
        }
        if ((statCatAnnot = stat.getClass().getAnnotation(HasCategory.class)) != null) {
            stat.setCategory(this.getCategory(UtilityMethods.enumName((String)statCatAnnot.cat())));
        }
        if (MMOItems.plugin.getTypes() != null) {
            MMOItems.plugin.getTypes().getAll().stream().filter(stat::isCompatible).forEach(type -> type.getAvailableStats().add(stat));
        }
    }

    private void registerCustomStat(@NotNull ConfigurationSection section) {
        Class statClass;
        String name = section.getString("name");
        String type = section.getString("type");
        Validate.notNull((Object)section, (String)"Cannot register a custom stat from a null section");
        Validate.notNull((Object)name, (String)"Cannot register a custom stat without a name");
        Validate.notNull((Object)type, (String)"Cannot register a custom stat without a type");
        switch (type.toLowerCase()) {
            case "double": {
                statClass = DoubleStat.class;
                break;
            }
            case "boolean": {
                statClass = BooleanStat.class;
                break;
            }
            case "text": {
                statClass = StringStat.class;
                break;
            }
            case "text-list": {
                statClass = StringListStat.class;
                break;
            }
            default: {
                throw new RuntimeException("Cannot register a custom stat of type " + type);
            }
        }
        String statId = String.format("custom_%s", name.replace(" ", "_")).toUpperCase();
        String[] lore = new String[]{};
        if (section.isList("lore")) {
            lore = section.getStringList("lore").toArray(new String[0]);
        } else if (section.isString("lore")) {
            lore = new String[]{section.getString("lore")};
        }
        try {
            ItemStat stat = (ItemStat)statClass.getConstructor(String.class, Material.class, String.class, String[].class, String[].class, Material[].class).newInstance(statId, Material.PAPER, name, lore, new String[]{"!miscellaneous", "!block", "all"}, new Material[0]);
            this.register(stat);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to create a custom stat of type " + type, e);
        }
    }

    @Deprecated
    public void register(@Nullable String id, @NotNull ItemStat<?, ?> stat) {
        this.register(stat);
    }

    @Deprecated
    public void loadInternalStats() {
        this.loadBuiltins();
    }
}

