/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.manager;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ConfigFile;
import net.Indyuce.mmoitems.skill.RegisteredSkill;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkillManager {
    private final Map<String, RegisteredSkill> skills = new HashMap<String, RegisteredSkill>();

    @Nullable
    public RegisteredSkill getSkill(String id) {
        return this.skills.get(id);
    }

    @NotNull
    public RegisteredSkill getSkillOrThrow(String id) {
        return Objects.requireNonNull(this.skills.get(id), "Could not find skill with ID '" + id + "'");
    }

    public void registerSkill(RegisteredSkill skill) {
        this.skills.put(Objects.requireNonNull(skill, "Skill cannot be null").getHandler().getId(), skill);
    }

    public boolean hasSkill(String id) {
        return this.skills.containsKey(id);
    }

    @NotNull
    public Collection<RegisteredSkill> getAll() {
        return this.skills.values();
    }

    public void initialize(boolean clearBefore) {
        File skillFolder;
        if (clearBefore) {
            this.skills.clear();
        }
        if (!(skillFolder = new File(MMOItems.plugin.getDataFolder() + "/skill")).exists()) {
            try {
                skillFolder.mkdir();
                for (SkillHandler handler : MythicLib.plugin.getSkills().getHandlers()) {
                    InputStream res = MMOItems.plugin.getResource("default/skill/" + handler.getLowerCaseId() + ".yml");
                    if (res == null) continue;
                    Files.copy(res, new File(MMOItems.plugin.getDataFolder() + "/skill/" + handler.getLowerCaseId() + ".yml").getAbsoluteFile().toPath(), new CopyOption[0]);
                }
            }
            catch (IOException exception) {
                MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not save default ability configs: " + exception.getMessage());
            }
        }
        for (SkillHandler handler : MythicLib.plugin.getSkills().getHandlers()) {
            ConfigFile config = new ConfigFile("/skill", handler.getLowerCaseId());
            if (!config.exists()) {
                config.getConfig().set("name", (Object)UtilityMethods.caseOnWords((String)handler.getId().replace("_", " ").replace("-", " ").toLowerCase()));
                for (String mod : handler.getModifiers()) {
                    config.getConfig().set("modifier." + mod + ".name", (Object)UtilityMethods.caseOnWords((String)mod.replace("-", " ").toLowerCase()));
                    config.getConfig().set("modifier." + mod + ".default-value", (Object)0);
                }
                config.save();
            }
            try {
                this.skills.put(handler.getId(), new RegisteredSkill(handler, (ConfigurationSection)config.getConfig()));
            }
            catch (RuntimeException exception) {
                MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not load skill '" + handler.getId() + "': " + exception.getMessage());
            }
        }
    }
}

