/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.manager;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.crafting.recipes.MythicRecipeBlueprint;
import io.lumine.mythic.lib.api.crafting.uifilters.VanillaUIFilter;
import io.lumine.mythic.lib.api.crafting.uimanager.ProvidedUIFilter;
import io.lumine.mythic.lib.api.util.Ref;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackCategory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackMessage;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.crafting.MMOItemUIFilter;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.recipe.workbench.ingredients.AirIngredient;
import net.Indyuce.mmoitems.api.recipe.workbench.ingredients.MMOItemIngredient;
import net.Indyuce.mmoitems.api.recipe.workbench.ingredients.VanillaIngredient;
import net.Indyuce.mmoitems.api.recipe.workbench.ingredients.WorkbenchIngredient;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.gui.edition.recipe.RecipeTypeListGUI;
import net.Indyuce.mmoitems.gui.edition.recipe.gui.RecipeEditorGUI;
import net.Indyuce.mmoitems.gui.edition.recipe.registry.RecipeRegistry;
import net.Indyuce.mmoitems.gui.edition.recipe.registry.burninglegacy.BurningRecipeInformation;
import net.Indyuce.mmoitems.manager.Reloadable;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeManager
implements Reloadable {
    private final ArrayList<Recipe> loadedLegacyRecipes = new ArrayList();
    private final ArrayList<MythicRecipeBlueprint> customRecipes = new ArrayList();
    private final ArrayList<MythicRecipeBlueprint> booklessRecipes = new ArrayList();
    @NotNull
    private final ArrayList<NamespacedKey> blacklistedFromAutomaticDiscovery = new ArrayList();
    private boolean book;
    @Nullable
    private ArrayList<NamespacedKey> generatedNamespacedKeys;

    public void loadRecipes() {
        this.book = MMOItems.plugin.getConfig().getBoolean("recipes.use-recipe-book");
        FriendlyFeedbackProvider ffp = new FriendlyFeedbackProvider((FriendlyFeedbackPalette)FFPMMOItems.get());
        ffp.activatePrefix(true, "Custom Crafting");
        for (Type type : MMOItems.plugin.getTypes().getAll()) {
            FileConfiguration config = type.getConfigFile().getConfig();
            for (MMOItemTemplate template : MMOItems.plugin.getTemplates().getTemplates(type)) {
                if (!config.contains(template.getId() + ".base.crafting")) continue;
                ConfigurationSection section = RecipeEditorGUI.getSection((ConfigurationSection)config, template.getId() + ".base.crafting");
                for (String recipeType : RecipeTypeListGUI.getRegisteredRecipes()) {
                    if (!section.contains(recipeType)) continue;
                    RecipeRegistry rr = RecipeTypeListGUI.getRegisteredRecipe(recipeType);
                    ConfigurationSection typeSection = RecipeEditorGUI.getSection(section, recipeType);
                    for (String recipeName : typeSection.getKeys(false)) {
                        NamespacedKey nk = this.getRecipeKey(template.getType(), template.getId(), recipeType, recipeName);
                        Ref nkRef = new Ref((Object)nk);
                        FriendlyFeedbackProvider ffpMinor = new FriendlyFeedbackProvider((FriendlyFeedbackPalette)FFPMMOItems.get());
                        ffpMinor.activatePrefix(true, "Recipe of $u" + template.getType() + " " + template.getId());
                        try {
                            MythicRecipeBlueprint blueprint = rr.sendToMythicLib(template, typeSection, recipeName, (Ref<NamespacedKey>)nkRef, ffpMinor);
                            (nkRef.getValue() != null ? this.customRecipes : this.booklessRecipes).add(blueprint);
                        }
                        catch (IllegalArgumentException error) {
                            if (error.getMessage().isEmpty()) continue;
                            MMOItems.print(null, "Cannot register custom recipe '$u{2}$b' for $e{0} {1}$b;$f {3}", "Custom Crafting", type.getId(), template.getId(), recipeName, error.getMessage());
                            ffpMinor.sendTo(FriendlyFeedbackCategory.ERROR, MMOItems.getConsole());
                            ffpMinor.sendTo(FriendlyFeedbackCategory.FAILURE, MMOItems.getConsole());
                        }
                    }
                }
            }
        }
        ffp.sendTo(FriendlyFeedbackCategory.ERROR, MMOItems.getConsole());
        ffp.sendTo(FriendlyFeedbackCategory.FAILURE, MMOItems.getConsole());
        Bukkit.getScheduler().runTask((Plugin)MMOItems.plugin, () -> this.getBukkitRecipes().forEach(Bukkit::addRecipe));
    }

    @Deprecated
    public void registerBurningRecipe(@NotNull BurningRecipeType recipeType, @NotNull MMOItem mmo, @NotNull BurningRecipeInformation info, int amount, @NotNull NamespacedKey key, boolean hidden) {
        ItemStack stack = mmo.newBuilder().build();
        stack.setAmount(amount);
        CookingRecipe<?> recipe = recipeType.provideRecipe(key, stack, info.getChoice().toBukkit(), info.getExp(), info.getBurnTime());
        this.loadedLegacyRecipes.add((Recipe)recipe);
        if (hidden) {
            this.blacklistedFromAutomaticDiscovery.add(key);
        }
    }

    @NotNull
    public ArrayList<Recipe> getBukkitRecipes() {
        return this.loadedLegacyRecipes;
    }

    @NotNull
    public ArrayList<MythicRecipeBlueprint> getCustomRecipes() {
        return this.customRecipes;
    }

    @NotNull
    public ArrayList<MythicRecipeBlueprint> getBooklessRecipes() {
        return this.booklessRecipes;
    }

    public ArrayList<NamespacedKey> getNamespacedKeys() {
        if (this.generatedNamespacedKeys != null) {
            return this.generatedNamespacedKeys;
        }
        this.generatedNamespacedKeys = new ArrayList();
        this.customRecipes.forEach(blueprint -> this.generatedNamespacedKeys.add(blueprint.getNk()));
        this.loadedLegacyRecipes.forEach(recipe -> this.generatedNamespacedKeys.add(((Keyed)recipe).getKey()));
        return this.generatedNamespacedKeys;
    }

    @NotNull
    public NamespacedKey getRecipeKey(@NotNull Type type, @NotNull String id, @NotNull String recipeType, @NotNull String number) {
        return new NamespacedKey((Plugin)MMOItems.plugin, recipeType + "_" + type.getId() + "_" + id + "_" + number);
    }

    @Override
    public void reload() {
        Bukkit.getScheduler().runTask((Plugin)MMOItems.plugin, () -> {
            for (NamespacedKey recipe : this.getNamespacedKeys()) {
                if (recipe == null) continue;
                try {
                    Bukkit.removeRecipe((NamespacedKey)recipe);
                }
                catch (Throwable e) {
                    MMOItems.print(null, "Could not register crafting book recipe for $r{0}$b:$f {1}", "MMOItems Custom Crafting", recipe.getKey(), e.getMessage());
                }
            }
            this.loadedLegacyRecipes.clear();
            this.blacklistedFromAutomaticDiscovery.clear();
            this.customRecipes.forEach(blueprint -> {
                try {
                    blueprint.disable();
                    Bukkit.removeRecipe((NamespacedKey)blueprint.getNk());
                }
                catch (Throwable throwable) {
                    MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not unregister knowledge book recipe '" + blueprint.getNk() + "': " + throwable.getMessage());
                }
            });
            this.customRecipes.clear();
            for (MythicRecipeBlueprint b : this.booklessRecipes) {
                b.disable();
            }
            this.booklessRecipes.clear();
            this.generatedNamespacedKeys = null;
            this.loadRecipes();
            if (this.book) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    this.refreshRecipeBook(player);
                }
            }
        });
    }

    public void refreshRecipeBook(Player player) {
        if (!this.book) {
            for (NamespacedKey key : player.getDiscoveredRecipes()) {
                if (!"mmoitems".equals(key.getNamespace())) continue;
                player.undiscoverRecipe(key);
            }
            return;
        }
        if (MythicLib.plugin.getVersion().isStrictlyHigher(new int[]{1, 16})) {
            for (NamespacedKey key : player.getDiscoveredRecipes()) {
                if (!"mmoitems".equals(key.getNamespace()) || this.getNamespacedKeys().contains(key)) continue;
                player.undiscoverRecipe(key);
            }
            for (NamespacedKey recipe : this.getNamespacedKeys()) {
                if (recipe == null) continue;
                boolean blacklisted = false;
                for (NamespacedKey black : this.blacklistedFromAutomaticDiscovery) {
                    if (!recipe.equals((Object)black)) continue;
                    blacklisted = true;
                    break;
                }
                if (blacklisted) continue;
                try {
                    if (player.hasDiscoveredRecipe(recipe)) continue;
                    player.discoverRecipe(recipe);
                }
                catch (Throwable e) {
                    MMOItems.print(null, "Could not register crafting book recipe for $r{0}$b:$f {1}", "MMOItems Custom Crafting", recipe.getKey(), e.getMessage());
                }
            }
            return;
        }
        for (NamespacedKey recipe : this.getNamespacedKeys()) {
            if (recipe == null) continue;
            boolean blacklisted = false;
            for (NamespacedKey black : this.blacklistedFromAutomaticDiscovery) {
                if (!recipe.equals((Object)black)) continue;
                blacklisted = true;
                break;
            }
            if (blacklisted) continue;
            try {
                player.discoverRecipe(recipe);
            }
            catch (Throwable e) {
                MMOItems.print(null, "Could not register crafting book recipe for $r{0}$b:$f {1}", "MMOItems Custom Crafting", recipe.getKey(), e.getMessage());
            }
        }
    }

    @NotNull
    public static WorkbenchIngredient getWorkbenchIngredient(@NotNull String input) throws IllegalArgumentException {
        ProvidedUIFilter poof = ProvidedUIFilter.getFromString((String)RecipeEditorGUI.poofFromLegacy(input), null);
        if (poof == null) {
            return new AirIngredient();
        }
        FriendlyFeedbackProvider ffp = new FriendlyFeedbackProvider((FriendlyFeedbackPalette)FFPMMOItems.get());
        if (!poof.isValid(ffp)) {
            throw new IllegalArgumentException(SilentNumbers.collapseList((ArrayList)SilentNumbers.transcribeList((List)ffp.getFeedbackOf(FriendlyFeedbackCategory.ERROR), s -> ((FriendlyFeedbackMessage)s).forConsole((FriendlyFeedbackPalette)FFPMMOItems.get())), (String)". "));
        }
        int amount = poof.getAmount(0);
        if (poof.getParent() instanceof MMOItemUIFilter) {
            Type miType = MMOItems.plugin.getTypes().getOrThrow(poof.getArgument());
            MMOItemTemplate mmo = MMOItems.plugin.getTemplates().getTemplateOrThrow(miType, poof.getData());
            return new MMOItemIngredient(miType, mmo.getId(), amount);
        }
        if (poof.getParent() instanceof VanillaUIFilter) {
            return new VanillaIngredient(Material.valueOf((String)poof.getArgument().toUpperCase().replace("-", "_").replace(" ", "_")), amount);
        }
        throw new IllegalArgumentException("Unsupported ingredient, you may only specify vanilla or mmoitems.");
    }

    @Deprecated
    public static enum BurningRecipeType {
        FURNACE(FurnaceRecipe::new),
        SMOKER(SmokingRecipe::new),
        CAMPFIRE(CampfireRecipe::new),
        BLAST(BlastingRecipe::new);

        private final RecipeProvider provider;

        private BurningRecipeType(RecipeProvider provider) {
            this.provider = provider;
        }

        public CookingRecipe<?> provideRecipe(NamespacedKey key, ItemStack result, RecipeChoice source, float experience, int cookTime) {
            return this.provider.provide(key, result, source, experience, cookTime);
        }

        public String getPath() {
            return this.name().toLowerCase();
        }
    }

    @FunctionalInterface
    public static interface RecipeProvider {
        public CookingRecipe<?> provide(NamespacedKey var1, ItemStack var2, RecipeChoice var3, float var4, int var5);
    }
}

