/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.manager;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.crafting.Layout;
import net.Indyuce.mmoitems.manager.Reloadable;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LayoutManager
implements Reloadable {
    private final Map<String, Layout> layouts = new HashMap<String, Layout>();

    @Override
    public void reload() {
        this.layouts.clear();
        for (File file : new File(MMOItems.plugin.getDataFolder() + "/layouts").listFiles()) {
            try {
                Layout layout = new Layout(file.getName().substring(0, file.getName().length() - 4), (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
                this.layouts.put(layout.getId(), layout);
            }
            catch (IllegalArgumentException exception) {
                MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not load layout '" + file.getName() + "': " + exception.getMessage());
            }
        }
    }

    public boolean hasLayout(String id) {
        return this.layouts.containsKey(id);
    }

    public Collection<Layout> getLayouts() {
        return this.layouts.values();
    }

    public Layout getLayout(String id) {
        return this.layouts.getOrDefault(id, this.layouts.get("default"));
    }
}

