/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.manager;

import io.lumine.mythic.lib.UtilityMethods;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ConfigFile;
import net.Indyuce.mmoitems.api.block.CustomBlock;
import net.Indyuce.mmoitems.api.droptable.DropTable;
import net.Indyuce.mmoitems.api.event.ItemDropEvent;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.manager.Reloadable;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DropTableManager
implements Listener,
Reloadable {
    private final Map<EntityType, DropTable> monsters = new HashMap<EntityType, DropTable>();
    private final Map<Material, DropTable> blocks = new HashMap<Material, DropTable>();
    private final Map<Integer, DropTable> customBlocks = new HashMap<Integer, DropTable>();

    public DropTableManager() {
        this.reload();
    }

    @Override
    public void reload() {
        this.monsters.clear();
        this.blocks.clear();
        this.customBlocks.clear();
        FileConfiguration config = new ConfigFile("drops").getConfig();
        if (config.contains("monsters")) {
            for (String key : config.getConfigurationSection("monsters").getKeys(false)) {
                try {
                    EntityType type = EntityType.valueOf((String)key.toUpperCase().replace("-", "_").replace(" ", "_"));
                    this.monsters.put(type, new DropTable(config.getConfigurationSection("monsters." + key)));
                }
                catch (IllegalArgumentException exception) {
                    MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not read drop table with mob type '" + key + "': " + exception.getMessage());
                }
            }
        }
        if (config.contains("blocks")) {
            for (String key : config.getConfigurationSection("blocks").getKeys(false)) {
                try {
                    Material material = Material.valueOf((String)key.toUpperCase().replace("-", "_").replace(" ", "_"));
                    this.blocks.put(material, new DropTable(config.getConfigurationSection("blocks." + key)));
                }
                catch (IllegalArgumentException exception) {
                    MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not read drop table with material '" + key + "': " + exception.getMessage());
                }
            }
        }
        if (config.contains("customblocks")) {
            for (String key : config.getConfigurationSection("customblocks").getKeys(false)) {
                try {
                    int id = Integer.parseInt(key);
                    this.customBlocks.put(id, new DropTable(config.getConfigurationSection("customblocks." + key)));
                }
                catch (IllegalArgumentException exception) {
                    MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not read drop table with custom block '" + key + "': " + exception.getMessage());
                }
            }
        }
    }

    @EventHandler
    public void entityDrops(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Player killer = entity.getKiller();
        if (killer != null && killer.hasMetadata("NPC")) {
            return;
        }
        if (this.monsters.containsKey(entity.getType())) {
            List<ItemStack> drops = this.monsters.get(entity.getType()).read(killer != null ? PlayerData.get((OfflinePlayer)killer) : null, false);
            ItemDropEvent called = new ItemDropEvent((LivingEntity)killer, drops, (Entity)entity);
            Bukkit.getPluginManager().callEvent((Event)called);
            if (called.isCancelled()) {
                return;
            }
            event.getDrops().addAll(drops);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void blockDrops(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (player == null || player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Block block = event.getBlock();
        Optional<CustomBlock> opt = MMOItems.plugin.getCustomBlocks().getFromBlock(block.getBlockData());
        if (opt.isPresent()) {
            CustomBlock customBlock = opt.get();
            if (this.customBlocks.containsKey(customBlock.getId()) && MMOUtils.getPickaxePower(player) >= customBlock.getRequiredPower()) {
                PlayerData playerData = PlayerData.get((OfflinePlayer)player);
                List<ItemStack> drops = this.customBlocks.get(customBlock.getId()).read(playerData, this.hasSilkTouchTool(player));
                ItemDropEvent called = new ItemDropEvent((LivingEntity)player, drops, customBlock);
                Bukkit.getPluginManager().callEvent((Event)called);
                if (called.isCancelled()) {
                    return;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)MMOItems.plugin, () -> {
                    for (ItemStack drop : drops) {
                        UtilityMethods.dropItemNaturally((Location)block.getLocation(), (ItemStack)drop);
                    }
                }, 2L);
            }
        } else if (this.blocks.containsKey(block.getType())) {
            Material type = block.getType();
            List<ItemStack> drops = this.blocks.get(type).read(PlayerData.get((OfflinePlayer)player), this.hasSilkTouchTool(player));
            ItemDropEvent called = new ItemDropEvent((LivingEntity)player, drops, block);
            Bukkit.getPluginManager().callEvent((Event)called);
            if (called.isCancelled()) {
                return;
            }
            Bukkit.getScheduler().runTaskLater((Plugin)MMOItems.plugin, () -> {
                for (ItemStack drop : drops) {
                    UtilityMethods.dropItemNaturally((Location)block.getLocation(), (ItemStack)drop);
                }
            }, 2L);
        }
    }

    public boolean hasSilkTouchTool(Player player) {
        ItemStack item = player.getInventory().getItemInMainHand();
        return item != null && item.getType() != Material.AIR && item.hasItemMeta() && item.getItemMeta().hasEnchant(Enchantment.SILK_TOUCH);
    }
}

