/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.manager;

import io.lumine.mythic.lib.api.MMOLineConfig;
import io.lumine.mythic.lib.api.item.NBTItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ConfigFile;
import net.Indyuce.mmoitems.api.crafting.ConditionalDisplay;
import net.Indyuce.mmoitems.api.crafting.CraftingStation;
import net.Indyuce.mmoitems.api.crafting.LoadedCraftingObject;
import net.Indyuce.mmoitems.api.crafting.condition.ClassCondition;
import net.Indyuce.mmoitems.api.crafting.condition.Condition;
import net.Indyuce.mmoitems.api.crafting.condition.FoodCondition;
import net.Indyuce.mmoitems.api.crafting.condition.LevelCondition;
import net.Indyuce.mmoitems.api.crafting.condition.ManaCondition;
import net.Indyuce.mmoitems.api.crafting.condition.PermissionCondition;
import net.Indyuce.mmoitems.api.crafting.condition.PlaceholderCondition;
import net.Indyuce.mmoitems.api.crafting.condition.StaminaCondition;
import net.Indyuce.mmoitems.api.crafting.ingredient.Ingredient;
import net.Indyuce.mmoitems.api.crafting.ingredient.IngredientType;
import net.Indyuce.mmoitems.api.crafting.ingredient.MMOItemIngredient;
import net.Indyuce.mmoitems.api.crafting.ingredient.VanillaIngredient;
import net.Indyuce.mmoitems.api.crafting.ingredient.inventory.MMOItemPlayerIngredient;
import net.Indyuce.mmoitems.api.crafting.ingredient.inventory.PlayerIngredient;
import net.Indyuce.mmoitems.api.crafting.ingredient.inventory.VanillaPlayerIngredient;
import net.Indyuce.mmoitems.api.crafting.trigger.CommandTrigger;
import net.Indyuce.mmoitems.api.crafting.trigger.MMOItemTrigger;
import net.Indyuce.mmoitems.api.crafting.trigger.MessageTrigger;
import net.Indyuce.mmoitems.api.crafting.trigger.SoundTrigger;
import net.Indyuce.mmoitems.api.crafting.trigger.Trigger;
import net.Indyuce.mmoitems.api.crafting.trigger.VanillaTrigger;
import net.Indyuce.mmoitems.comp.mythicmobs.crafting.MythicMobsSkillTrigger;
import net.Indyuce.mmoitems.manager.Reloadable;
import net.Indyuce.mmoitems.util.PluginUtils;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class CraftingManager
implements Reloadable {
    private final List<IngredientType> ingredients = new ArrayList<IngredientType>();
    private final Map<String, LoadedCraftingObject<Condition>> conditions = new HashMap<String, LoadedCraftingObject<Condition>>();
    private final Map<String, LoadedCraftingObject<Trigger>> triggers = new HashMap<String, LoadedCraftingObject<Trigger>>();
    private final Map<String, CraftingStation> stations = new HashMap<String, CraftingStation>();

    public CraftingManager() {
        this.registerCondition("level", LevelCondition::new, new ConditionalDisplay("&a\u2714 Requires Level #level#", "&c\u2716 Requires Level #level#"));
        this.registerCondition("permission", PermissionCondition::new, new ConditionalDisplay("&a\u2714 #display#", "&c\u2716 #display#"));
        this.registerCondition("placeholder", PlaceholderCondition::new, new ConditionalDisplay("&a\u2714 #display#", "&c\u2716 #display#"));
        this.registerCondition("mana", ManaCondition::new, new ConditionalDisplay("&a\u2714 Requires #mana# Mana", "&c\u2716 Requires #mana# Mana"));
        this.registerCondition("stamina", StaminaCondition::new, new ConditionalDisplay("&a\u2714 Requires #stamina# Stamina", "&c\u2716 Requires #stamina# Stamina"));
        this.registerCondition("food", FoodCondition::new, new ConditionalDisplay("&a\u2714 Requires #food# Food", "&c\u2716 Requires #food# Food"));
        this.registerCondition("class", ClassCondition::new, new ConditionalDisplay("&a\u2714 Required Class: #class#", "&c\u2716 Required Class: #class#"));
        this.registerTrigger("command", CommandTrigger::new);
        this.registerTrigger("message", MessageTrigger::new);
        this.registerTrigger("sound", SoundTrigger::new);
        this.registerTrigger("vanilla", VanillaTrigger::new);
        this.registerTrigger("mmoitem", MMOItemTrigger::new);
        this.registerIngredient("vanilla", VanillaIngredient::new, new ConditionalDisplay("&8\u2714 &7#amount# #item#", "&c\u2716 &7#amount# #item#"), nbt -> true, VanillaPlayerIngredient::new);
        this.registerIngredient("mmoitem", MMOItemIngredient::new, new ConditionalDisplay("&8\u2714 &7#amount# #level##item#", "&c\u2716 &7#amount# #level##item#"), NBTItem::hasType, MMOItemPlayerIngredient::new);
        PluginUtils.isDependencyPresent("MythicMobs", unused -> this.registerTrigger("mmskill", MythicMobsSkillTrigger::new));
    }

    @Override
    public void reload() {
        String path;
        this.stations.clear();
        ConfigFile language = new ConfigFile("/language", "crafting-stations");
        for (LoadedCraftingObject<Condition> condition : this.getConditions()) {
            path = "condition." + condition.getId();
            if (!language.getConfig().contains(path)) {
                language.getConfig().createSection(path);
                condition.getDisplay().setup(language.getConfig().getConfigurationSection(path));
            }
            condition.setDisplay(new ConditionalDisplay(language.getConfig().getConfigurationSection(path)));
        }
        for (IngredientType ingredient : this.getIngredients()) {
            path = "ingredient." + ingredient.getId();
            if (!language.getConfig().contains(path)) {
                language.getConfig().createSection(path);
                ingredient.getDisplay().setup(language.getConfig().getConfigurationSection(path));
            }
            ingredient.setDisplay(new ConditionalDisplay(language.getConfig().getConfigurationSection(path)));
        }
        language.save();
        for (File file : new File(MMOItems.plugin.getDataFolder() + "/crafting-stations").listFiles()) {
            try {
                CraftingStation station = new CraftingStation(file.getName().substring(0, file.getName().length() - 4), (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
                this.stations.put(station.getId(), station);
            }
            catch (IllegalArgumentException | NullPointerException exception) {
                MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not load station '" + file.getName() + "': " + exception.getMessage());
            }
        }
        for (CraftingStation station : this.stations.values()) {
            try {
                station.getPostLoadAction().performAction();
            }
            catch (IllegalArgumentException exception) {
                MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not post-load station '" + station.getId() + "': " + exception.getMessage());
            }
        }
    }

    public int countRecipes() {
        int t = 0;
        for (CraftingStation station : this.stations.values()) {
            t += station.getRecipes().size();
        }
        return t;
    }

    public boolean hasStation(String id) {
        return this.stations.containsKey(id);
    }

    public Collection<CraftingStation> getStations() {
        return this.stations.values();
    }

    public CraftingStation getStation(String id) {
        return this.stations.get(id);
    }

    @NotNull
    public Ingredient getIngredient(MMOLineConfig config) {
        String key = config.getKey();
        for (IngredientType ingredient : this.ingredients) {
            if (!ingredient.getId().equals(key)) continue;
            return (Ingredient)ingredient.load(config);
        }
        throw new IllegalArgumentException("Could not match ingredient");
    }

    @NotNull
    public Condition getCondition(MMOLineConfig config) {
        return this.getConditionInfo(config.getKey()).load(config);
    }

    @NotNull
    public LoadedCraftingObject<Condition> getConditionInfo(String key) {
        return Objects.requireNonNull(this.conditions.get(key), "Could not match condition");
    }

    @NotNull
    public Trigger getTrigger(MMOLineConfig config) {
        return this.getTriggerInfo(config.getKey()).load(config);
    }

    @NotNull
    public LoadedCraftingObject<Trigger> getTriggerInfo(String key) {
        return Objects.requireNonNull(this.triggers.get(key), "Could not match trigger");
    }

    public List<IngredientType> getIngredients() {
        return this.ingredients;
    }

    public Collection<LoadedCraftingObject<Condition>> getConditions() {
        return this.conditions.values();
    }

    public Collection<LoadedCraftingObject<Trigger>> getTriggers() {
        return this.triggers.values();
    }

    public void registerIngredient(String id, Function<MMOLineConfig, Ingredient> function, ConditionalDisplay display, Predicate<NBTItem> check, Function<NBTItem, PlayerIngredient> readIngredient) {
        this.ingredients.add(0, new IngredientType(id, function, display, check, readIngredient));
    }

    public void registerCondition(String id, Function<MMOLineConfig, Condition> function, @NotNull ConditionalDisplay display) {
        LoadedCraftingObject<Condition> obj = new LoadedCraftingObject<Condition>(id, function, Objects.requireNonNull(display, "Conditional display cannot be null"));
        this.conditions.put(obj.getId(), obj);
    }

    public void registerTrigger(String id, Function<MMOLineConfig, Trigger> function) {
        LoadedCraftingObject<Trigger> obj = new LoadedCraftingObject<Trigger>(id, function, null);
        this.triggers.put(obj.getId(), obj);
    }

    public Collection<CraftingStation> getAll() {
        return this.stations.values();
    }
}

