/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.manager;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.skill.trigger.TriggerType;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ConfigFile;
import net.Indyuce.mmoitems.api.ReforgeOptions;
import net.Indyuce.mmoitems.api.item.util.ConfigItem;
import net.Indyuce.mmoitems.api.item.util.ConfigItems;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.manager.Reloadable;
import net.Indyuce.mmoitems.stat.GemUpgradeScaling;
import net.Indyuce.mmoitems.stat.LuteAttackEffectStat;
import net.Indyuce.mmoitems.util.LanguageFile;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class ConfigManager
implements Reloadable {
    private ConfigFile loreFormat;
    private ConfigFile dynLore;
    private final Map<TriggerType, String> triggerTypeNames = new HashMap<TriggerType, String>();
    private final Map<PotionEffectType, String> potionNames = new HashMap<PotionEffectType, String>();
    public boolean replaceMushroomDrops;
    public boolean worldGenEnabled;
    public boolean upgradeRequirementsCheck;
    public boolean keepSoulboundOnDeath;
    public boolean rerollOnItemUpdate;
    public boolean opStatsEnabled;
    public boolean disableRemovedItems;
    public double soulboundBaseDamage;
    public double soulboundPerLvlDamage;
    public double levelSpread;
    public NumericStatFormula defaultItemCapacity;
    public ReforgeOptions revisionOptions;
    public ReforgeOptions gemRevisionOptions;
    public ReforgeOptions phatLootsOptions;
    public final List<String> opStats = new ArrayList<String>();
    public String itemTypeLoreTag;
    public String gemStoneLoreTag;
    public String defaultTierName;

    public ConfigManager() {
        File craftingStationsFolder;
        this.mkdir("layouts");
        this.mkdir("item");
        this.mkdir("language");
        this.mkdir("language/lore-formats");
        File modifiersFolder = new File(MMOItems.plugin.getDataFolder() + "/modifiers");
        if (!modifiersFolder.exists()) {
            this.mkdir("modifiers");
            DefaultFile.EXAMPLE_MODIFIERS.checkFile();
        }
        if (!(craftingStationsFolder = new File(MMOItems.plugin.getDataFolder() + "/crafting-stations")).exists()) {
            if (craftingStationsFolder.mkdir()) {
                try {
                    JarFile jarFile = new JarFile(MMOItems.plugin.getJarFile());
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        String name = entries.nextElement().getName();
                        if (!name.startsWith("default/crafting-stations/") || name.length() <= "default/crafting-stations/".length()) continue;
                        Files.copy(MMOItems.plugin.getResource(name), new File(MMOItems.plugin.getDataFolder() + "/crafting-stations", name.split("/")[2]).toPath(), new CopyOption[0]);
                    }
                    jarFile.close();
                }
                catch (IOException exception) {
                    MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not load default crafting stations.");
                }
            } else {
                MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not create directory!");
            }
        }
        for (DefaultFile file : DefaultFile.values()) {
            if (!file.isAutomatic()) continue;
            file.checkFile();
        }
        MMOItems.plugin.getTypes().getAll().forEach(type -> type.getConfigFile().setup());
        this.reload();
    }

    private void loadTranslations() {
        ConfigFile items = new ConfigFile("/language", "items");
        for (ConfigItem item : ConfigItems.values) {
            if (!items.getConfig().contains(item.getId())) {
                items.getConfig().createSection(item.getId());
                item.setup(items.getConfig().getConfigurationSection(item.getId()));
            }
            item.update((ConfigurationSection)items.getConfig());
        }
        items.save();
        LanguageFile messages = new LanguageFile("messages");
        for (Message message : Message.values()) {
            String path = message.name().toLowerCase().replace("_", "-");
            if (!messages.getConfig().contains(path)) {
                messages.getConfig().set(path, (Object)message.getDefault());
            }
            message.setRaw(messages.getConfig().getString(path));
        }
        messages.save();
        FileConfiguration statsConfig = new ConfigFile("/language", "stats").getConfig();
        this.itemTypeLoreTag = statsConfig.getString("item-type", "");
        this.gemStoneLoreTag = statsConfig.getString("gem-stone-lore", "");
        LanguageFile potionEffects = new LanguageFile("potion-effects");
        for (PotionEffectType effect : PotionEffectType.values()) {
            this.potionNames.put(effect, potionEffects.computeTranslation(effect.getName().toLowerCase().replace("_", "-"), () -> UtilityMethods.caseOnWords((String)effect.getName().toLowerCase().replace("_", " "))));
        }
        potionEffects.save();
        LanguageFile attackEffects = new LanguageFile("attack-effects");
        for (LuteAttackEffectStat.LuteAttackEffect eff : LuteAttackEffectStat.LuteAttackEffect.values()) {
            eff.setName(attackEffects.computeTranslation("lute-attack." + eff.name().toLowerCase().replace("_", "-"), () -> UtilityMethods.caseOnWords((String)eff.name().toLowerCase().replace("_", " "))));
        }
        attackEffects.save();
        this.triggerTypeNames.clear();
        FileConfiguration abilities = new ConfigFile("/language", "abilities").getConfig();
        for (TriggerType type : TriggerType.values()) {
            this.triggerTypeNames.put(type, abilities.getString("cast-mode." + type.getLowerCaseId(), type.getName()));
        }
    }

    @Override
    public void reload() {
        MMOItems.plugin.reloadConfig();
        this.loreFormat = new ConfigFile("/language", "lore-format");
        this.dynLore = new ConfigFile("/language", "dynamic-lore");
        this.loadTranslations();
        this.replaceMushroomDrops = MMOItems.plugin.getConfig().getBoolean("custom-blocks.replace-mushroom-drops");
        this.worldGenEnabled = MMOItems.plugin.getConfig().getBoolean("custom-blocks.enable-world-gen");
        this.soulboundBaseDamage = MMOItems.plugin.getConfig().getDouble("soulbound.damage.base");
        this.soulboundPerLvlDamage = MMOItems.plugin.getConfig().getDouble("soulbound.damage.per-lvl");
        this.upgradeRequirementsCheck = MMOItems.plugin.getConfig().getBoolean("item-upgrade-requirements-check");
        GemUpgradeScaling.defaultValue = MMOItems.plugin.getConfig().getString("gem-upgrade-default", GemUpgradeScaling.SUBSEQUENT.getId());
        this.keepSoulboundOnDeath = MMOItems.plugin.getConfig().getBoolean("soulbound.keep-on-death");
        this.rerollOnItemUpdate = MMOItems.plugin.getConfig().getBoolean("item-revision.reroll-when-updated");
        this.levelSpread = MMOItems.plugin.getConfig().getDouble("item-level-spread");
        this.disableRemovedItems = MMOItems.plugin.getConfig().getBoolean("disable-removed-items");
        this.defaultTierName = MMOItems.plugin.getConfig().getString("default-tier-name");
        NumericStatFormula.RELATIVE_SPREAD = !MMOItems.plugin.getConfig().getBoolean("additive-spread-formula", false);
        this.opStatsEnabled = MMOItems.plugin.getConfig().getBoolean("op-item-stats.enabled");
        this.opStats.clear();
        for (String key : MMOItems.plugin.getConfig().getStringList("op-item-stats.stats")) {
            this.opStats.add(UtilityMethods.enumName((String)key));
        }
        ConfigurationSection keepData = MMOItems.plugin.getConfig().getConfigurationSection("item-revision.keep-data");
        ConfigurationSection phatLoots = MMOItems.plugin.getConfig().getConfigurationSection("item-revision.phat-loots");
        ConfigurationSection gemKeepData = MMOItems.plugin.getConfig().getConfigurationSection("item-revision.keep-gem-data");
        ReforgeOptions.dropRestoredGems = MMOItems.plugin.getConfig().getBoolean("item-revision.drop-extra-gems", true);
        this.revisionOptions = keepData != null ? new ReforgeOptions(keepData) : new ReforgeOptions();
        this.gemRevisionOptions = gemKeepData != null ? new ReforgeOptions(gemKeepData) : new ReforgeOptions();
        this.phatLootsOptions = phatLoots != null ? new ReforgeOptions(phatLoots) : new ReforgeOptions();
        List exemptedPhatLoots = MMOItems.plugin.getConfig().getStringList("item-revision.disable-phat-loot");
        for (String epl : exemptedPhatLoots) {
            this.phatLootsOptions.addToBlacklist(epl);
        }
        try {
            this.defaultItemCapacity = new NumericStatFormula(MMOItems.plugin.getConfig().getConfigurationSection("default-item-capacity"));
        }
        catch (IllegalArgumentException exception) {
            this.defaultItemCapacity = new NumericStatFormula(5.0, 0.05, 0.1, 0.3);
            MMOItems.plugin.getLogger().log(Level.SEVERE, "An error occurred while trying to load default capacity formula for the item generator, using default: " + exception.getMessage());
        }
        ConfigFile items = new ConfigFile("/language", "items");
        for (ConfigItem item : ConfigItems.values) {
            item.update(items.getConfig().getConfigurationSection(item.getId()));
        }
    }

    public boolean isBlacklisted(@NotNull Material material) {
        return MMOItems.plugin.getConfig().getStringList("block-blacklist").contains(material.name());
    }

    @Deprecated
    @NotNull
    public String getStatFormat(String path) {
        FileConfiguration config = new ConfigFile("/language", "stats").getConfig();
        String found = config.getString(path);
        return found == null ? "<TranslationNotFound:" + path + ">" : found;
    }

    @Deprecated
    public String getMessage(String path) {
        return Message.valueOf(UtilityMethods.enumName((String)path)).getFormatted();
    }

    @Deprecated
    @NotNull
    public String getCastingModeName(@NotNull TriggerType triggerType) {
        return this.getTriggerTypeName(triggerType);
    }

    @NotNull
    public String getTriggerTypeName(@NotNull TriggerType triggerType) {
        return Objects.requireNonNull(this.triggerTypeNames.get(triggerType), "Trigger type name for '" + triggerType.name() + "' not found");
    }

    @Deprecated
    public String getModifierName(String path) {
        return UtilityMethods.caseOnWords((String)path.toLowerCase().replace("-", " ").replace("_", " "));
    }

    @NotNull
    public List<String> getDefaultLoreFormat() {
        return this.loreFormat.getConfig().getStringList("lore-format");
    }

    @NotNull
    public String getPotionEffectName(PotionEffectType type) {
        return Objects.requireNonNull(this.potionNames.get(type), "Potion effect name for '" + type.getName() + "' not found");
    }

    @Deprecated
    public String getLuteAttackEffectName(LuteAttackEffectStat.LuteAttackEffect effect) {
        return effect.getName();
    }

    @Deprecated
    public String getDynLoreFormat(String input) {
        return this.dynLore.getConfig().getString("format." + input);
    }

    private void mkdir(String path) {
        File folder = new File(MMOItems.plugin.getDataFolder() + "/" + path);
        if (!folder.exists() && !folder.mkdir()) {
            MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not create directory!");
        }
    }

    public static enum DefaultFile {
        ITEM_TIERS("", "item-tiers"),
        ITEM_TYPES("", "item-types", true),
        DROPS("", "drops"),
        ITEM_SETS("", "item-sets"),
        GEN_TEMPLATES("", "gen-templates"),
        UPGRADE_TEMPLATES("", "upgrade-templates"),
        EXAMPLE_MODIFIERS("modifiers", "example_modifiers", true),
        CUSTOM_STATS("", "custom-stats"),
        ABILITIES("language", "abilities"),
        ATTACK_EFFECTS("language", "attack-effects"),
        CRAFTING_STATIONS("language", "crafting-stations"),
        ITEMS("language", "items"),
        LORE_FORMAT("language", "lore-format"),
        MESSAGES("language", "messages"),
        POTION_EFFECTS("language", "potion-effects"),
        STATS("language", "stats"),
        DEFAULT_LAYOUT("layouts", "default"),
        EXPANDED_LAYOUT("layouts", "expanded"),
        ARMOR,
        AXE,
        BLOCK,
        BOW,
        CATALYST,
        CONSUMABLE,
        CROSSBOW,
        DAGGER,
        GAUNTLET,
        GEM_STONE,
        GREATAXE,
        GREATHAMMER,
        GREATSTAFF,
        GREATSWORD,
        HALBERD,
        HAMMER,
        KATANA,
        LANCE,
        LONG_SWORD,
        MATERIAL,
        MISCELLANEOUS,
        MUSKET,
        OFF_CATALYST,
        ORNAMENT,
        SHIELD,
        SPEAR,
        STAFF,
        SWORD,
        TALISMAN,
        THRUSTING_SWORD,
        TOME,
        TOOL,
        WAND,
        WHIP;

        private final String folderPath;
        private final String fileName;
        private final boolean manual;

        private DefaultFile() {
            this.fileName = this.name().toLowerCase() + ".yml";
            this.folderPath = "item";
            this.manual = false;
        }

        private DefaultFile(String folderPath, String fileName) {
            this(folderPath, fileName, false);
        }

        private DefaultFile(String folderPath, String fileName, boolean manual) {
            this.folderPath = folderPath;
            this.fileName = fileName + ".yml";
            this.manual = manual;
        }

        public boolean isAutomatic() {
            return !this.manual;
        }

        public File getFile() {
            return new File(MMOItems.plugin.getDataFolder() + (this.folderPath.equals("") ? "" : "/" + this.folderPath), this.fileName);
        }

        public void checkFile() {
            File file = this.getFile();
            if (!file.exists()) {
                try {
                    if (!new YamlConverter(file).convert()) {
                        Files.copy(MMOItems.plugin.getResource("default/" + (this.folderPath.isEmpty() ? "" : this.folderPath + "/") + this.fileName), file.getAbsoluteFile().toPath(), new CopyOption[0]);
                    }
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public static class YamlConverter {
        private final File file;
        private final String fileName;

        public YamlConverter(File newConfig) {
            this.file = newConfig;
            this.fileName = newConfig.getName();
        }

        public boolean convert() throws IOException {
            if (!this.file.exists() && this.fileName.equalsIgnoreCase("block.yml") && new File(MMOItems.plugin.getDataFolder(), "custom-blocks.yml").exists() && this.file.createNewFile()) {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)new File(MMOItems.plugin.getDataFolder(), "custom-blocks.yml"));
                for (String id : config.getKeys(false)) {
                    ConfigurationSection section = config.getConfigurationSection(id);
                    section.set("material", (Object)"STONE");
                    section.set("block-id", (Object)Integer.parseInt(id));
                    for (String node : section.getKeys(false)) {
                        Object value = section.get(node);
                        if (!node.equalsIgnoreCase("display-name")) continue;
                        section.set("display-name", null);
                        section.set("name", value);
                    }
                }
                config.save(this.file);
                MMOItems.plugin.getLogger().log(Level.CONFIG, "Successfully converted custom-blocks.yml");
                return true;
            }
            return false;
        }
    }
}

