/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.listener;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.event.PlayerAttackEvent;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.comp.interaction.InteractionType;
import io.lumine.mythic.lib.damage.MeleeAttackMetadata;
import io.lumine.mythic.lib.entity.ProjectileMetadata;
import io.lumine.mythic.lib.entity.ProjectileType;
import io.lumine.mythic.lib.player.cooldown.CooldownObject;
import io.lumine.mythic.lib.skill.SimpleSkill;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.trigger.TriggerMetadata;
import io.lumine.mythic.lib.skill.trigger.TriggerType;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.event.item.SpecialWeaponAttackEvent;
import net.Indyuce.mmoitems.api.interaction.Consumable;
import net.Indyuce.mmoitems.api.interaction.GemStone;
import net.Indyuce.mmoitems.api.interaction.ItemSkin;
import net.Indyuce.mmoitems.api.interaction.Tool;
import net.Indyuce.mmoitems.api.interaction.UseItem;
import net.Indyuce.mmoitems.api.interaction.projectile.ArrowParticles;
import net.Indyuce.mmoitems.api.interaction.weapon.Weapon;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;

public class ItemUse
implements Listener {
    @EventHandler
    public void rightClickEffects(PlayerInteractEvent event) {
        boolean rightClick;
        if (!event.hasItem()) {
            return;
        }
        NBTItem item = MythicLib.plugin.getVersion().getWrapper().getNBTItem(event.getItem());
        Type itemType = Type.get(item);
        if (itemType == null) {
            return;
        }
        Player player = event.getPlayer();
        UseItem useItem = itemType.toUseItem(player, item);
        if (useItem instanceof Consumable && ((Consumable)useItem).hasVanillaEating()) {
            return;
        }
        if (!useItem.checkItemRequirements()) {
            event.setUseItemInHand(Event.Result.DENY);
            return;
        }
        boolean bl = rightClick = event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK;
        if (rightClick) {
            if (useItem.getPlayerData().getMMOPlayerData().getCooldownMap().isOnCooldown((CooldownObject)useItem.getMMOItem())) {
                double cd = useItem.getPlayerData().getMMOPlayerData().getCooldownMap().getCooldown((CooldownObject)useItem.getMMOItem());
                Message.ITEM_ON_COOLDOWN.format(ChatColor.RED, "#left#", MythicLib.plugin.getMMOConfig().decimal.format(cd), "#s#", cd >= 2.0 ? "s" : "").send(player);
                event.setUseItemInHand(Event.Result.DENY);
                return;
            }
            if (useItem instanceof Consumable) {
                event.setUseItemInHand(Event.Result.DENY);
                Consumable.ConsumableConsumeResult result = ((Consumable)useItem).useOnPlayer(event.getHand(), false);
                if (result == Consumable.ConsumableConsumeResult.CANCEL) {
                    return;
                }
                if (result == Consumable.ConsumableConsumeResult.CONSUME) {
                    event.getItem().setAmount(event.getItem().getAmount() - 1);
                }
            }
            useItem.getPlayerData().getMMOPlayerData().getCooldownMap().applyCooldown((CooldownObject)useItem.getMMOItem(), useItem.getNBTItem().getStat("ITEM_COOLDOWN"));
            useItem.executeCommands();
        }
        if (useItem instanceof Weapon) {
            ((Weapon)useItem).handleUntargetedAttack(rightClick, EquipmentSlot.fromBukkit((org.bukkit.inventory.EquipmentSlot)event.getHand()));
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void meleeAttacks(PlayerAttackEvent event) {
        if (!(event.getAttack() instanceof MeleeAttackMetadata)) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack weaponUsed = player.getInventory().getItem(((MeleeAttackMetadata)event.getAttack()).getHand().toBukkit());
        NBTItem item = MythicLib.plugin.getVersion().getWrapper().getNBTItem(weaponUsed);
        Type itemType = Type.get(item);
        if (itemType == null || itemType == Type.BLOCK) {
            return;
        }
        if (!itemType.hasMeleeAttacks()) {
            event.setCancelled(true);
            return;
        }
        PlayerData playerData = PlayerData.get((OfflinePlayer)player);
        Weapon weapon = new Weapon(playerData, item);
        if (!weapon.checkItemRequirements()) {
            event.setCancelled(true);
            return;
        }
        if (!weapon.handleTargetedAttack(event.getAttack(), event.getAttacker(), event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void specialToolAbilities(BlockBreakEvent event) {
        if (UtilityMethods.isFake((Event)event)) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        NBTItem item = MythicLib.plugin.getVersion().getWrapper().getNBTItem(player.getInventory().getItemInMainHand());
        if (!item.hasType()) {
            return;
        }
        Tool tool = new Tool(PlayerData.get((OfflinePlayer)player), item);
        if (!tool.checkItemRequirements()) {
            event.setCancelled(true);
            return;
        }
        if (tool.miningEffects(block)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void rightClickWeaponInteractions(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        if (!(event.getRightClicked() instanceof LivingEntity)) {
            return;
        }
        NBTItem item = MythicLib.plugin.getVersion().getWrapper().getNBTItem(player.getInventory().getItem(event.getHand()));
        Type itemType = Type.get(item);
        if (itemType == null) {
            return;
        }
        LivingEntity target = (LivingEntity)event.getRightClicked();
        if (!UtilityMethods.canTarget((Player)player, (Entity)target, (InteractionType)InteractionType.OFFENSE_ACTION)) {
            return;
        }
        UseItem usableItem = itemType.toUseItem(player, item);
        if (!usableItem.checkItemRequirements()) {
            return;
        }
        SkillHandler<?> onEntityInteract = usableItem.getMMOItem().getType().onEntityInteract();
        if (onEntityInteract != null) {
            SpecialWeaponAttackEvent called = new SpecialWeaponAttackEvent(usableItem.getPlayerData(), (Weapon)usableItem, target);
            Bukkit.getPluginManager().callEvent((Event)called);
            if (!called.isCancelled()) {
                new SimpleSkill(onEntityInteract).cast(new TriggerMetadata(usableItem.getPlayerData().getMMOPlayerData(), TriggerType.API, (Entity)target));
            }
        }
    }

    @EventHandler
    public void gemStonesAndItemStacks(InventoryClickEvent event) {
        Object result;
        NBTItem picked;
        Player player = (Player)event.getWhoClicked();
        if (event.getAction() != InventoryAction.SWAP_WITH_CURSOR) {
            return;
        }
        NBTItem item = MythicLib.plugin.getVersion().getWrapper().getNBTItem(event.getCursor());
        Type type = Type.get(item);
        if (type == null) {
            return;
        }
        UseItem useItem = type.toUseItem(player, item);
        if (!useItem.checkItemRequirements()) {
            return;
        }
        if (useItem instanceof ItemSkin) {
            picked = MythicLib.plugin.getVersion().getWrapper().getNBTItem(event.getCurrentItem());
            if (!picked.hasType()) {
                return;
            }
            result = ((ItemSkin)useItem).applyOntoItem(picked, Type.get(picked.getType()));
            if (((ItemSkin.ApplyResult)result).getType() == ItemSkin.ResultType.NONE) {
                return;
            }
            event.setCancelled(true);
            item.getItem().setAmount(item.getItem().getAmount() - 1);
            if (((ItemSkin.ApplyResult)result).getType() == ItemSkin.ResultType.FAILURE) {
                return;
            }
            event.setCurrentItem(((ItemSkin.ApplyResult)result).getResult());
        }
        if (useItem instanceof GemStone) {
            picked = MythicLib.plugin.getVersion().getWrapper().getNBTItem(event.getCurrentItem());
            if (!picked.hasType()) {
                return;
            }
            result = ((GemStone)useItem).applyOntoItem(picked, Type.get(picked.getType()));
            if (((GemStone.ApplyResult)result).getType() == GemStone.ResultType.NONE) {
                return;
            }
            event.setCancelled(true);
            item.getItem().setAmount(item.getItem().getAmount() - 1);
            if (((GemStone.ApplyResult)result).getType() == GemStone.ResultType.FAILURE) {
                return;
            }
            event.setCurrentItem(((GemStone.ApplyResult)result).getResult());
        }
        if (useItem instanceof Consumable && event.getCurrentItem() != null && event.getCurrentItem().getType() != Material.AIR && ((Consumable)useItem).useOnItem(event, MythicLib.plugin.getVersion().getWrapper().getNBTItem(event.getCurrentItem()))) {
            event.setCancelled(true);
            event.getCursor().setAmount(event.getCursor().getAmount() - 1);
        }
    }

    @EventHandler
    public void handleCustomBows(EntityShootBowEvent event) {
        if (!(event.getProjectile() instanceof AbstractArrow) || !(event.getEntity() instanceof Player)) {
            return;
        }
        NBTItem item = NBTItem.get((ItemStack)event.getBow());
        Type type = Type.get(item.getType());
        if (type != null) {
            PlayerData playerData = PlayerData.get((OfflinePlayer)((Player)event.getEntity()));
            Weapon weapon = new Weapon(playerData, item);
            if (!weapon.checkItemRequirements() || !weapon.checkAndApplyWeaponCosts()) {
                event.setCancelled(true);
                return;
            }
            ItemStack itemInMainHand = playerData.getPlayer().getInventory().getItemInMainHand();
            EquipmentSlot bowSlot = itemInMainHand.isSimilar(event.getBow()) ? EquipmentSlot.MAIN_HAND : EquipmentSlot.OFF_HAND;
            ProjectileMetadata proj = ProjectileMetadata.create((MMOPlayerData)playerData.getMMOPlayerData(), (EquipmentSlot)bowSlot, (ProjectileType)ProjectileType.ARROW, (Entity)event.getProjectile());
            proj.setSourceItem(item);
            proj.setCustomDamage(true);
            proj.setDamageMultiplier(MMOUtils.getForce(event));
            if (item.hasTag("MMOITEMS_ARROW_PARTICLES")) {
                new ArrowParticles((AbstractArrow)event.getProjectile(), item);
            }
            AbstractArrow arrow = (AbstractArrow)event.getProjectile();
            double arrowVelocity = proj.getShooter().getStat("ARROW_VELOCITY");
            if (arrowVelocity > 0.0) {
                arrow.setVelocity(arrow.getVelocity().multiply(arrowVelocity));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void handleVanillaEatenConsumables(PlayerItemConsumeEvent event) {
        NBTItem item = MythicLib.plugin.getVersion().getWrapper().getNBTItem(event.getItem());
        Type itemType = Type.get(item);
        if (itemType == null) {
            return;
        }
        Player player = event.getPlayer();
        UseItem useItem = itemType.toUseItem(player, item);
        if (!useItem.checkItemRequirements()) {
            event.setCancelled(true);
            return;
        }
        if (useItem instanceof Consumable) {
            if (useItem.getPlayerData().getMMOPlayerData().getCooldownMap().isOnCooldown((CooldownObject)useItem.getMMOItem())) {
                double cd = useItem.getPlayerData().getMMOPlayerData().getCooldownMap().getCooldown((CooldownObject)useItem.getMMOItem());
                Message.ITEM_ON_COOLDOWN.format(ChatColor.RED, "#left#", MythicLib.plugin.getMMOConfig().decimal.format(cd), "#s#", cd >= 2.0 ? "s" : "").send(player);
                event.setCancelled(true);
                return;
            }
            Consumable.ConsumableConsumeResult result = ((Consumable)useItem).useOnPlayer(event.getItem().equals((Object)player.getInventory().getItemInMainHand()) ? org.bukkit.inventory.EquipmentSlot.HAND : org.bukkit.inventory.EquipmentSlot.OFF_HAND, true);
            if (result == Consumable.ConsumableConsumeResult.CANCEL) {
                event.setCancelled(true);
                return;
            }
            if (result == Consumable.ConsumableConsumeResult.NOT_CONSUME) {
                event.setCancelled(true);
            }
            useItem.getPlayerData().getMMOPlayerData().getCooldownMap().applyCooldown((CooldownObject)useItem.getMMOItem(), useItem.getNBTItem().getStat("ITEM_COOLDOWN"));
            useItem.executeCommands();
        }
    }
}

