/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition.recipe.registry;

import io.lumine.mythic.lib.api.crafting.ingredients.ShapedIngredient;
import io.lumine.mythic.lib.api.crafting.outputs.MRORecipe;
import io.lumine.mythic.lib.api.crafting.outputs.MythicRecipeOutput;
import io.lumine.mythic.lib.api.crafting.recipes.MythicRecipe;
import io.lumine.mythic.lib.api.crafting.recipes.MythicRecipeBlueprint;
import io.lumine.mythic.lib.api.crafting.recipes.MythicRecipeStation;
import io.lumine.mythic.lib.api.crafting.recipes.ShapedRecipe;
import io.lumine.mythic.lib.api.crafting.uifilters.UIFilter;
import io.lumine.mythic.lib.api.crafting.uimanager.ProvidedUIFilter;
import io.lumine.mythic.lib.api.util.Ref;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import java.util.ArrayList;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.api.crafting.MMOItemUIFilter;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.gui.edition.recipe.gui.RMG_SuperShaped;
import net.Indyuce.mmoitems.gui.edition.recipe.gui.RecipeEditorGUI;
import net.Indyuce.mmoitems.gui.edition.recipe.interpreter.RMGRI_SuperShaped;
import net.Indyuce.mmoitems.gui.edition.recipe.registry.RecipeRegistry;
import net.Indyuce.mmoitems.stat.data.StringData;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RMGRR_SuperShaped
implements RecipeRegistry {
    @NotNull
    final ItemStack displayListItem = RecipeEditorGUI.rename(new ItemStack(Material.NOTE_BLOCK), FFPMMOItems.get().getExampleFormat() + "Super Shaped Recipe");

    @Override
    @NotNull
    public String getRecipeConfigPath() {
        return "supershaped";
    }

    @Override
    @NotNull
    public String getRecipeTypeName() {
        return "Super Shaped";
    }

    @Override
    @NotNull
    public ItemStack getDisplayListItem() {
        return this.displayListItem;
    }

    @Override
    public void openForPlayer(@NotNull EditionInventory inv, @NotNull String recipeName, Object ... otherParams) {
        new RMG_SuperShaped(inv.getPlayer(), inv.getEdited(), recipeName, this).open(inv);
    }

    @Override
    @NotNull
    public MythicRecipeBlueprint sendToMythicLib(@NotNull MMOItemTemplate template, @NotNull ConfigurationSection recipeTypeSection, @NotNull String recipeName, @NotNull Ref<NamespacedKey> namespace, @NotNull FriendlyFeedbackProvider ffp) throws IllegalArgumentException {
        String permission;
        ConfigurationSection recipeSection = RecipeEditorGUI.moveInput(recipeTypeSection, recipeName);
        NamespacedKey nk = (NamespacedKey)namespace.getValue();
        if (nk == null) {
            throw new IllegalArgumentException(FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Illegal (Null) Namespace", (String[])new String[0]));
        }
        ShapedRecipe input = RMGRR_SuperShaped.superShapedRecipeFromList(nk.getKey(), new ArrayList<String>(recipeSection.getStringList("input")), ffp);
        if (input == null) {
            throw new IllegalArgumentException(FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Shaped recipe containing only AIR, $fignored$b.", (String[])new String[0]));
        }
        ShapedRecipe output = RMGRR_SuperShaped.superShapedRecipeFromList(nk.getKey(), new ArrayList<String>(recipeSection.getStringList("output")), ffp);
        int outputAmount = recipeSection.getInt("amount", 1);
        ShapedRecipe outputItem = ShapedRecipe.single((String)nk.getKey(), (ProvidedUIFilter[])new ProvidedUIFilter[]{new ProvidedUIFilter((UIFilter)MMOItemUIFilter.get(), template.getType().getId(), template.getId(), Math.max(outputAmount, 1))});
        MRORecipe outputRecipe = new MRORecipe(outputItem, output);
        MythicRecipeBlueprint ret = new MythicRecipeBlueprint((MythicRecipe)input, (MythicRecipeOutput)outputRecipe, nk);
        RandomStatData perm = template.getBaseItemData().get(ItemStats.CRAFT_PERMISSION);
        if (perm instanceof StringData && (permission = ((StringData)perm).getString()) != null) {
            ret.addRequiredPermission(permission);
        }
        ret.deploy(MythicRecipeStation.WORKBENCH, null);
        namespace.setValue(null);
        return ret;
    }

    @Nullable
    public static ShapedRecipe superShapedRecipeFromList(@NotNull String namespace, @NotNull ArrayList<String> recipe, @NotNull FriendlyFeedbackProvider ffp) throws IllegalArgumentException {
        ArrayList<ShapedIngredient> poofs = new ArrayList<ShapedIngredient>();
        boolean nonAirFound = false;
        int rowNumber = 0;
        for (String row : recipe) {
            String updatedRow = RMGRI_SuperShaped.updateRow(row);
            String[] positions = updatedRow.contains("|") ? updatedRow.split("\\|") : updatedRow.split(" ");
            if (positions.length != 5) {
                throw new IllegalArgumentException("Invalid super crafting table row $u" + updatedRow + "$b ($fNot exactly 5 ingredients wide$b).");
            }
            ProvidedUIFilter left = RecipeEditorGUI.readIngredientFrom(positions[0], ffp);
            ProvidedUIFilter midLeft = RecipeEditorGUI.readIngredientFrom(positions[1], ffp);
            ProvidedUIFilter center = RecipeEditorGUI.readIngredientFrom(positions[2], ffp);
            ProvidedUIFilter midRight = RecipeEditorGUI.readIngredientFrom(positions[3], ffp);
            ProvidedUIFilter right = RecipeEditorGUI.readIngredientFrom(positions[4], ffp);
            if (!left.isAir()) {
                nonAirFound = true;
            }
            if (!midLeft.isAir()) {
                nonAirFound = true;
            }
            if (!center.isAir()) {
                nonAirFound = true;
            }
            if (!midRight.isAir()) {
                nonAirFound = true;
            }
            if (!right.isAir()) {
                nonAirFound = true;
            }
            ShapedIngredient leftIngredient = new ShapedIngredient(left, 0, -rowNumber);
            ShapedIngredient midLeftIngredient = new ShapedIngredient(midLeft, 1, -rowNumber);
            ShapedIngredient centerIngredient = new ShapedIngredient(center, 2, -rowNumber);
            ShapedIngredient midRightIngredient = new ShapedIngredient(midRight, 3, -rowNumber);
            ShapedIngredient rightIngredient = new ShapedIngredient(right, 4, -rowNumber);
            poofs.add(leftIngredient);
            poofs.add(midLeftIngredient);
            poofs.add(centerIngredient);
            poofs.add(midRightIngredient);
            poofs.add(rightIngredient);
            ++rowNumber;
        }
        if (!nonAirFound) {
            return null;
        }
        return ShapedRecipe.unsharpen((ShapedRecipe)new ShapedRecipe(namespace, poofs));
    }
}

