/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition.recipe.registry;

import io.lumine.mythic.lib.api.crafting.ingredients.ShapedIngredient;
import io.lumine.mythic.lib.api.crafting.outputs.MRORecipe;
import io.lumine.mythic.lib.api.crafting.outputs.MythicRecipeOutput;
import io.lumine.mythic.lib.api.crafting.recipes.MythicRecipe;
import io.lumine.mythic.lib.api.crafting.recipes.MythicRecipeBlueprint;
import io.lumine.mythic.lib.api.crafting.recipes.MythicRecipeStation;
import io.lumine.mythic.lib.api.crafting.recipes.ShapedRecipe;
import io.lumine.mythic.lib.api.crafting.uifilters.UIFilter;
import io.lumine.mythic.lib.api.crafting.uimanager.ProvidedUIFilter;
import io.lumine.mythic.lib.api.util.Ref;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import java.util.ArrayList;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.api.crafting.MMOItemUIFilter;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.gui.edition.recipe.gui.RMG_Shaped;
import net.Indyuce.mmoitems.gui.edition.recipe.gui.RecipeEditorGUI;
import net.Indyuce.mmoitems.gui.edition.recipe.interpreter.RMGRI_Shaped;
import net.Indyuce.mmoitems.gui.edition.recipe.registry.RecipeRegistry;
import net.Indyuce.mmoitems.stat.data.StringData;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RMGRR_Shaped
implements RecipeRegistry {
    @NotNull
    final ItemStack displayListItem = RecipeEditorGUI.rename(new ItemStack(Material.CRAFTING_TABLE), FFPMMOItems.get().getExampleFormat() + "Shaped Recipe");

    @Override
    @NotNull
    public String getRecipeConfigPath() {
        return "shaped";
    }

    @Override
    @NotNull
    public String getRecipeTypeName() {
        return "Shaped";
    }

    @Override
    @NotNull
    public ItemStack getDisplayListItem() {
        return this.displayListItem;
    }

    @Override
    public void openForPlayer(@NotNull EditionInventory inv, @NotNull String recipeName, Object ... otherParams) {
        new RMG_Shaped(inv.getPlayer(), inv.getEdited(), recipeName, this).open(inv);
    }

    @Override
    @NotNull
    public MythicRecipeBlueprint sendToMythicLib(@NotNull MMOItemTemplate template, @NotNull ConfigurationSection recipeTypeSection, @NotNull String recipeName, @NotNull Ref<NamespacedKey> namespace, @NotNull FriendlyFeedbackProvider ffp) throws IllegalArgumentException {
        String permission;
        ConfigurationSection recipeSection = RecipeEditorGUI.moveInput(recipeTypeSection, recipeName);
        NamespacedKey nk = (NamespacedKey)namespace.getValue();
        if (nk == null) {
            throw new IllegalArgumentException(FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Illegal (Null) Namespace", (String[])new String[0]));
        }
        ShapedRecipe input = RMGRR_Shaped.shapedRecipeFromList(nk.getKey(), new ArrayList<String>(recipeSection.getStringList("input")), ffp);
        if (input == null) {
            throw new IllegalArgumentException(FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Shaped recipe containing only AIR, $fignored$b.", (String[])new String[0]));
        }
        ShapedRecipe output = RMGRR_Shaped.shapedRecipeFromList(nk.getKey(), new ArrayList<String>(recipeSection.getStringList("output")), ffp);
        int outputAmount = recipeSection.getInt("amount", 1);
        boolean hideBook = recipeSection.getBoolean("hidden", false);
        ShapedRecipe outputItem = ShapedRecipe.single((String)nk.getKey(), (ProvidedUIFilter[])new ProvidedUIFilter[]{new ProvidedUIFilter((UIFilter)MMOItemUIFilter.get(), template.getType().getId(), template.getId(), Math.max(outputAmount, 1))});
        MRORecipe outputRecipe = new MRORecipe(outputItem, output);
        MythicRecipeBlueprint ret = new MythicRecipeBlueprint((MythicRecipe)input, (MythicRecipeOutput)outputRecipe, nk);
        RandomStatData perm = template.getBaseItemData().get(ItemStats.CRAFT_PERMISSION);
        if (perm instanceof StringData && (permission = ((StringData)perm).getString()) != null) {
            ret.addRequiredPermission(permission);
        }
        ret.deploy(MythicRecipeStation.WORKBENCH, namespace);
        if (hideBook) {
            namespace.setValue(null);
        }
        return ret;
    }

    @Nullable
    public static ShapedRecipe shapedRecipeFromList(@NotNull String namespace, @NotNull ArrayList<String> recipe, @NotNull FriendlyFeedbackProvider ffp) throws IllegalArgumentException {
        ArrayList<ShapedIngredient> poofs = new ArrayList<ShapedIngredient>();
        boolean nonAirFound = false;
        int rowNumber = 0;
        for (String row : recipe) {
            String updatedRow = RMGRI_Shaped.updateRow(row);
            String[] positions = updatedRow.contains("|") ? updatedRow.split("\\|") : updatedRow.split(" ");
            if (positions.length != 3) {
                throw new IllegalArgumentException("Invalid crafting table row $u" + updatedRow + "$b ($fNot exactly 3 ingredients wide$b).");
            }
            ProvidedUIFilter left = RecipeEditorGUI.readIngredientFrom(positions[0], ffp);
            ProvidedUIFilter center = RecipeEditorGUI.readIngredientFrom(positions[1], ffp);
            ProvidedUIFilter right = RecipeEditorGUI.readIngredientFrom(positions[2], ffp);
            if (!left.isAir()) {
                nonAirFound = true;
            }
            if (!center.isAir()) {
                nonAirFound = true;
            }
            if (!right.isAir()) {
                nonAirFound = true;
            }
            ShapedIngredient leftIngredient = new ShapedIngredient(left, 0, -rowNumber);
            ShapedIngredient centerIngredient = new ShapedIngredient(center, 1, -rowNumber);
            ShapedIngredient rightIngredient = new ShapedIngredient(right, 2, -rowNumber);
            poofs.add(leftIngredient);
            poofs.add(centerIngredient);
            poofs.add(rightIngredient);
            ++rowNumber;
        }
        if (!nonAirFound) {
            return null;
        }
        return ShapedRecipe.unsharpen((ShapedRecipe)new ShapedRecipe(namespace, poofs));
    }
}

